/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.collections;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ConcurrentList<E>
implements List<E> {
    protected List<Ref<E>> values = new ArrayList<Ref<E>>();
    protected int delta = 0;
    protected int consolidatedUpToIndex = -1;
    protected List<WeakReference<ConcurrentIterator>> iterators = new ArrayList<WeakReference<ConcurrentIterator>>();

    private boolean consolidateUnsync(int upToIndex) {
        if (upToIndex < 0) {
            return false;
        }
        if (this.delta == 0) {
            return upToIndex < this.values.size();
        }
        if (upToIndex <= this.consolidatedUpToIndex) {
            return upToIndex < this.values.size();
        }
        ConcurrentIterator iterator = this.iterator();
        int i = 0;
        while (i <= upToIndex && this.delta > 0) {
            iterator.next();
            ++i;
        }
        iterator.dispose();
        this.consolidatedUpToIndex = upToIndex;
        if (this.consolidatedUpToIndex >= this.values.size()) {
            this.consolidatedUpToIndex = this.values.size() - 1;
            return false;
        }
        return true;
    }

    private void toBeRemovedUnsync(int index) {
        Iterator<WeakReference<ConcurrentIterator>> weakIterators = this.iterators.iterator();
        while (weakIterators.hasNext()) {
            WeakReference<ConcurrentIterator> weakIterator = weakIterators.next();
            ConcurrentIterator iterator = (ConcurrentIterator)weakIterator.get();
            if (iterator == null) {
                weakIterators.remove();
                continue;
            }
            if (iterator.index > index) {
                --iterator.index;
                continue;
            }
            if (iterator.index != index) continue;
            iterator.advanced = true;
        }
    }

    private void toBeAddedUnsync(int index) {
        if (index >= this.values.size()) {
            return;
        }
        Iterator<WeakReference<ConcurrentIterator>> weakIterators = this.iterators.iterator();
        while (weakIterators.hasNext()) {
            WeakReference<ConcurrentIterator> weakIterator = weakIterators.next();
            ConcurrentIterator iterator = (ConcurrentIterator)weakIterator.get();
            if (iterator == null) {
                weakIterators.remove();
                continue;
            }
            if (iterator.index > index) {
                ++iterator.index;
                continue;
            }
            if (iterator.index != index) continue;
            iterator.advanced = true;
        }
    }

    private void trueRemoveUnsync(int index) {
        this.toBeRemovedUnsync(index);
        Ref<E> element = this.values.remove(index);
        if (element == null) {
            --this.delta;
        }
    }

    @Override
    public int size() {
        int result = this.values.size() - this.delta;
        if (result < 0) {
            return 0;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.values.size() - this.delta <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            return this.values.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentIterator iterator() {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentIterator iterator = new ConcurrentIterator();
            this.iterators.add(new WeakReference<ConcurrentIterator>(iterator));
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            Object[] array = new Object[this.size()];
            int i = 0;
            for (Ref<E> reference : this.values) {
                if (reference == null) continue;
                array[i++] = reference.data;
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            if (a == null || a.length != this.size()) {
                return this.toArray();
            }
            int i = 0;
            for (Ref<E> ref : this.values) {
                if (ref == null) continue;
                a[i++] = ref.data;
            }
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            this.values.add(new Ref<E>(e));
            if (this.consolidatedUpToIndex + 2 >= this.values.size()) {
                ++this.consolidatedUpToIndex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object o) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentIterator iterator = this.iterator();
            int index = -1;
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                ++index;
                Object element = iterator.next();
                if (element == null) {
                    if (o != null) continue;
                    this.remove(index);
                    iterator.dispose();
                    return true;
                }
                if (element.equals(o)) break;
            }
            this.remove(index);
            iterator.dispose();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            Object o;
            Iterator<?> iterator = c.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.contains(o = iterator.next()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            for (E o : c) {
                this.add(o);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            int i = -1;
            for (E o : c) {
                this.add(index + ++i, o);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            boolean result = true;
            for (Object o : c) {
                boolean bl = result = this.remove(o) && result;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentIterator iterator = this.iterator();
            boolean changed = false;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (c.contains(e)) continue;
                this.remove(iterator.index);
                changed = true;
            }
            iterator.dispose();
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            this.values.clear();
            this.consolidatedUpToIndex = -1;
            this.delta = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            if (this.consolidateUnsync(index)) {
                return (E)this.values.get((int)index).data;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            if (this.consolidateUnsync(index)) {
                return (E)this.values.set((int)index, new Ref<E>(element)).data;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            if (!this.consolidateUnsync(index)) {
                if (index <= 0) {
                    if (this.values.size() == 0) {
                        this.add(element);
                    } else {
                        index = 0;
                    }
                } else {
                    this.add(element);
                    return;
                }
            }
            this.values.add(index, new Ref<E>(element));
            if (index < this.consolidatedUpToIndex) {
                ++this.consolidatedUpToIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            if (this.consolidateUnsync(index)) {
                Object removed = ((Ref)this.values.set((int)index, null)).data;
                ++this.delta;
                if (index <= this.consolidatedUpToIndex) {
                    this.consolidatedUpToIndex = index - 1;
                }
                return (E)removed;
            }
            return null;
        }
    }

    @Override
    public int indexOf(Object o) {
        ConcurrentIterator iterator = this.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            ++index;
            if (o == null) {
                if (iterator.next() != null) continue;
                iterator.dispose();
                return index;
            }
            if (!o.equals(iterator.next())) continue;
            iterator.dispose();
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ConcurrentIterator iterator = this.iterator();
        int index = -1;
        int lastIndex = 0;
        while (iterator.hasNext()) {
            ++index;
            if (o == null) {
                if (iterator.next() != null) continue;
                lastIndex = index;
                continue;
            }
            if (!o.equals(iterator.next())) continue;
            lastIndex = index;
        }
        iterator.dispose();
        return lastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator() {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentListIterator iterator = new ConcurrentListIterator();
            this.iterators.add(new WeakReference<ConcurrentListIterator>(iterator));
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentListIterator iterator = new ConcurrentListIterator();
            this.iterators.add(new WeakReference<ConcurrentListIterator>(iterator));
            int i = 0;
            while (i < index) {
                if (!iterator.hasNext()) break;
                iterator.next();
                ++i;
            }
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ConcurrentList result = new ConcurrentList();
        ConcurrentList concurrentList = this;
        synchronized (concurrentList) {
            ConcurrentListIterator iterator = new ConcurrentListIterator();
            int i = 0;
            while (i < fromIndex) {
                if (!iterator.hasNext()) break;
                iterator.next();
                ++i;
            }
            i = fromIndex;
            while (i < toIndex) {
                if (!iterator.hasNext()) break;
                result.add(iterator.next());
                ++i;
            }
            iterator.dispose();
        }
        return result;
    }

    static /* synthetic */ void access$1(ConcurrentList concurrentList, int n) {
        concurrentList.trueRemoveUnsync(n);
    }

    public class ConcurrentIterator
    implements Iterator<E> {
        protected int index = -1;
        protected boolean advanced = false;
        protected E lastElement = null;

        /*
         * Unable to fully structure code
         */
        private void advanceUnsync() {
            if (!this.advanced) {
                ++this.index;
            }
            this.advanced = true;
            if (this.index < ConcurrentList.this.values.size()) ** GOTO lbl8
            return;
            while (ConcurrentList.this.values.get(this.index) == null) {
                ConcurrentList.access$1(ConcurrentList.this, this.index);
lbl8:
                // 2 sources

                if (this.index < ConcurrentList.this.values.size()) continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ConcurrentList concurrentList = ConcurrentList.this;
            synchronized (concurrentList) {
                this.advanceUnsync();
                return this.index < ConcurrentList.this.values.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ConcurrentList concurrentList = ConcurrentList.this;
            synchronized (concurrentList) {
                this.advanceUnsync();
                if (this.index < ConcurrentList.this.values.size()) {
                    this.advanced = false;
                    this.lastElement = ConcurrentList.this.values.get((int)this.index).data;
                    return this.lastElement;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ConcurrentIterator concurrentIterator = this;
            synchronized (concurrentIterator) {
                if (this.index - 1 > 0 && this.index - 1 < ConcurrentList.this.values.size() && ConcurrentList.this.values.get(this.index) != null && ConcurrentList.this.values.get((int)this.index).data == this.lastElement) {
                    ConcurrentList.this.values.set(this.index - 1, null);
                    ++ConcurrentList.this.delta;
                    if (this.index <= ConcurrentList.this.consolidatedUpToIndex) {
                        ConcurrentList.this.consolidatedUpToIndex = this.index - 1;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ConcurrentList concurrentList = ConcurrentList.this;
            synchronized (concurrentList) {
                int i = 0;
                while (i < ConcurrentList.this.iterators.size()) {
                    WeakReference<ConcurrentIterator> iteratorRef = ConcurrentList.this.iterators.get(i);
                    if (iteratorRef.get() == this) {
                        ConcurrentList.this.iterators.remove(i);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class ConcurrentListIterator
    extends ConcurrentIterator
    implements ListIterator<E> {
        private ConcurrentListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public E previous() {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public int nextIndex() {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public int previousIndex() {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public void set(E e) {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public void add(E e) {
            throw new RuntimeException("Unsupported operation!");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported operation!");
        }
    }

    protected static class Ref<DATA> {
        public final DATA data;

        public Ref(DATA data) {
            this.data = data;
        }

        public String toString() {
            return "Ref[" + this.data + "]";
        }
    }
}

