/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.collections;

import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.collections.ConcurrentList;
import cz.cuni.amis.clear2d.engine.iface.IRenderable;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;

public class C2DRenderables<ELEM extends IRenderable>
implements IUpdatable {
    private ConcurrentList<ELEM> toAdd = new ConcurrentList();
    private ConcurrentList<ELEM> toRemove = new ConcurrentList();
    private ConcurrentList<ELEM> renderables = new ConcurrentList();
    private Camera camera;

    public C2DRenderables(Camera camera) {
        this.camera = camera;
    }

    public void add(ELEM renderable) {
        if (!this.toRemove.remove(renderable)) {
            this.toAdd.add(renderable);
        }
    }

    public boolean contains(ELEM renderable) {
        return this.renderables.contains(renderable) || this.toAdd.contains(renderable);
    }

    public void remove(ELEM renderable) {
        if (!this.toAdd.remove(renderable)) {
            this.toRemove.add(renderable);
        }
    }

    @Override
    public void update() {
        if (this.toRemove.size() > 0) {
            this.renderables.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        if (this.toAdd.size() > 0) {
            this.renderables.addAll(this.toAdd);
            this.toAdd.clear();
        }
        ConcurrentList.ConcurrentIterator iterator = this.renderables.iterator();
        while (iterator.hasNext()) {
            ((IRenderable)iterator.next()).render(this.camera);
        }
        iterator.dispose();
    }

    public String toString() {
        return "C2DRenderables[#count = " + this.renderables.size() + "]";
    }
}

