/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine;

import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.Component;
import cz.cuni.amis.clear2d.engine.collections.ConcurrentList;
import cz.cuni.amis.clear2d.engine.events.Event;
import cz.cuni.amis.clear2d.engine.events.Events;
import cz.cuni.amis.clear2d.engine.iface.IControllable;
import cz.cuni.amis.clear2d.engine.iface.INotifiable;
import cz.cuni.amis.clear2d.engine.math.Vector2;
import cz.cuni.amis.clear2d.utils.Lazy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SceneElement
implements INotifiable,
IControllable {
    protected Map<Class, ConcurrentList<Component>> components = new HashMap<Class, ConcurrentList<Component>>();
    protected ConcurrentList<Component> componentsOrdered = new ConcurrentList();
    public Vector2 pos = new Vector2();
    public float z = 0.0f;
    public SceneElement parent = null;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean ticking = true;
    public Lazy<ConcurrentList<SceneElement>> children = new Lazy<ConcurrentList<SceneElement>>(){

        @Override
        protected ConcurrentList<SceneElement> create() {
            return new ConcurrentList<SceneElement>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean add(SceneElement e) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        ConcurrentList.ConcurrentIterator iterator = this.iterator();
                        int index = -1;
                        do {
                            if (!iterator.hasNext()) {
                                this.values.add(new ConcurrentList.Ref<SceneElement>(e));
                                if (index < this.consolidatedUpToIndex) {
                                    ++this.consolidatedUpToIndex;
                                }
                                return true;
                            }
                            ++index;
                        } while (!(((SceneElement)iterator.next()).z > e.z));
                        this.values.add(index, new ConcurrentList.Ref<SceneElement>(e));
                        if (index < this.consolidatedUpToIndex) {
                            ++this.consolidatedUpToIndex;
                        }
                        iterator.dispose();
                        return true;
                    }
                }
            };
        }
    };

    public void addChild(SceneElement newChild) {
        newChild.setParent(this);
    }

    public void removeChild(SceneElement child) {
        if (this.children.isNull()) {
            return;
        }
        if (this.children.get().contains(child)) {
            child.setParent(null);
        }
    }

    public void setParent(SceneElement newParent) {
        if (this.parent == newParent) {
            return;
        }
        SceneElement oldParent = this.parent;
        if (this.parent != null) {
            this.parent.children.get().remove(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.children.get().add(this);
        }
        this.notify(Events.SCENE_ELEMENT_PARENT_CHANGED, this, newParent, oldParent);
    }

    public void setZ(float newZ) {
        this.z = newZ;
        if (this.parent != null) {
            this.parent.children.get().remove(this);
            this.parent.children.get().add(this);
        }
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
        if (this.enabled) {
            this.notify(Events.SCENE_ELEMENT_ENABLED, this);
        } else {
            this.notifyDo(Events.SCENE_ELEMENT_DISABLED, this);
        }
    }

    public Vector2 getGlobalPos() {
        Vector2 globalPos = new Vector2(this.pos);
        SceneElement parent = this.parent;
        while (parent != null) {
            globalPos.inAdd(parent.pos);
            parent = parent.parent;
        }
        return globalPos;
    }

    public Vector2 getLocalPos(Vector2 globalPos) {
        Vector2 localPos = new Vector2(globalPos);
        localPos.inSub(this.pos);
        SceneElement parent = this.parent;
        while (parent != null) {
            globalPos.inSub(parent.pos);
            parent = parent.parent;
        }
        return localPos;
    }

    public <COMPONENT> COMPONENT getComponent(Class<COMPONENT> componentClass) {
        return (COMPONENT)this.components.get(componentClass).iterator().next();
    }

    public <COMPONENT> Set<COMPONENT> getComponents(Class<COMPONENT> componentClass) {
        return (Set)((Object)this.components.get(componentClass));
    }

    public <COMPONENT extends Component> void addComponent(COMPONENT component) {
        ConcurrentList<Component> components = this.components.get(component.getClass());
        if (components == null) {
            components = new ConcurrentList();
            this.components.put(component.getClass(), components);
        }
        if (component.owner != null && component.owner != this) {
            component.owner.removeComponent(component);
        }
        component.owner = this;
        components.add(component);
        this.componentsOrdered.add(component);
    }

    public void removeComponent(Component component) {
        ConcurrentList<Component> components = this.components.get(component.getClass());
        if (components == null) {
            return;
        }
        components.remove(component);
        this.componentsOrdered.remove(component);
    }

    public void removeComponents(Class<? extends Component> componentClass) {
        this.components.remove(componentClass);
        boolean i = false;
        ConcurrentList.ConcurrentIterator iterator = this.componentsOrdered.iterator();
        while (iterator.hasNext()) {
            if (((Component)iterator.next()).getClass() != componentClass) continue;
            iterator.remove();
        }
        iterator.dispose();
    }

    @Override
    public void notify(Event event, Object ... params) {
        if (event.propagateToEnabledElements && !this.enabled) {
            return;
        }
        float dX = this.pos.x;
        float dY = this.pos.y;
        if (event == Events.RENDER) {
            if (!this.visible) {
                return;
            }
            ((Camera)params[0]).pushTranslation(dX, dY);
        } else if (event == Events.TICK && !this.ticking) {
            return;
        }
        this.notifyDo(event, params);
        if (event == Events.RENDER) {
            ((Camera)params[0]).popTranslation(dX, dY);
        }
    }

    private void notifyDo(Event event, Object ... params) {
        this.handleEvent(event, params);
        ConcurrentList.ConcurrentIterator cmpIterator = this.componentsOrdered.iterator();
        while (cmpIterator.hasNext()) {
            ((Component)cmpIterator.next()).notify(event, params);
        }
        cmpIterator.dispose();
        if (!this.children.isNull()) {
            ConcurrentList.ConcurrentIterator seIterator = this.children.get().iterator();
            while (seIterator.hasNext()) {
                ((SceneElement)seIterator.next()).notify(event, params);
            }
            seIterator.dispose();
        }
    }

    protected void handleEvent(Event event, Object ... params) {
    }
}

