/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine;

import cz.cuni.amis.clear2d.Clear2D;
import cz.cuni.amis.clear2d.engine.Camera;
import cz.cuni.amis.clear2d.engine.SceneRoot;
import cz.cuni.amis.clear2d.engine.events.Events;
import cz.cuni.amis.clear2d.engine.iface.IControllable;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.iface.IUpdatable;
import cz.cuni.amis.clear2d.engine.time.C2DTime;

public class Scene
implements IUpdatable,
ITickable,
IControllable {
    public final SceneRoot root = new SceneRoot();
    public Camera camera;
    public boolean enabled = false;

    public Scene() {
        this(null);
    }

    public Scene(Camera camera) {
        this.root.setEnabled(false);
        this.camera = camera;
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.enabled == state) {
            return;
        }
        this.enabled = state;
        if (this.enabled) {
            this.root.setEnabled(true);
            Clear2D.engine.renderUpdate.add(this);
            Clear2D.engine.tickUpdate.add(this);
        } else {
            this.root.setEnabled(false);
            Clear2D.engine.tickUpdate.remove(this);
        }
    }

    @Override
    public void update() {
        if (this.root == null) {
            return;
        }
        if (this.camera == null) {
            return;
        }
        this.camera.target.lock();
        try {
            this.root.notify(Events.RENDER, this.camera);
        }
        finally {
            this.camera.target.unlock();
        }
    }

    @Override
    public void tick(C2DTime time) {
        if (this.root == null) {
            return;
        }
        this.root.notify(Events.TICK, time);
    }
}

