/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine;

import cz.cuni.amis.clear2d.engine.RenderTarget;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.iface.IRender;
import cz.cuni.amis.clear2d.engine.math.Vector2;
import java.awt.Image;

public class Camera
implements IRender {
    public final float camW;
    public final float camH;
    public Vector2 translation = new Vector2();
    public final RenderTarget target;

    public Camera(int camW, int camH) {
        this.camW = camW;
        this.camH = camH;
        this.target = new RenderTarget(camW, camH);
    }

    public void pushTranslation(float x, float y) {
        this.translation.inAdd(x, y);
    }

    public void pushTranslation(Vector2 v) {
        this.translation.inAdd(v);
    }

    public void popTranslation(float x, float y) {
        this.translation.inSub(x, y);
    }

    public void popTranslation(Vector2 v) {
        this.translation.inSub(v);
    }

    @Override
    public void draw(Vector2 point, Image img) {
        if (point == null) {
            return;
        }
        this.drawInternal(point.x + this.translation.x, point.y + this.translation.y, img);
    }

    @Override
    public void draw(float x, float y, Image img) {
        this.drawInternal(x + this.translation.x, y + this.translation.y, img);
    }

    private void drawInternal(float camX, float camY, Image img) {
        this.target.draw(camX * this.target.widthF, camY * this.target.heightF, img);
    }

    @Override
    public void draw(Vector2 point, IDrawable img) {
        this.drawInternal(point.x + this.translation.x, point.y + this.translation.y, img);
    }

    @Override
    public void draw(float x, float y, IDrawable img) {
        this.drawInternal(x + this.translation.x, y + this.translation.y, img);
    }

    private void drawInternal(float camX, float camY, IDrawable img) {
        if (img == null) {
            return;
        }
        img.drawAt(this.target.graphics, camX, camY);
    }

    public void die() {
        try {
            this.target.die();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

