/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.tests;

import cz.cuni.amis.clear2d.engine.collections.ConcurrentList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Test;

public class Test00_ConcurrentList {
    private static AtomicLong totalOperations = new AtomicLong(0L);

    @Test
    public void test00() {
        totalOperations.set(0L);
        int threadCount = 1;
        int operCount = 10000;
        boolean logOperations = false;
        System.out.println("Creating barrier(" + threadCount + ")...");
        CyclicBarrier barrier = new CyclicBarrier(threadCount);
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        System.out.println("Creating " + threadCount + " worker threads...");
        int i = 0;
        while (i < threadCount) {
            threads.add(new Thread(new Worker("W" + i, list, operCount, barrier, i, logOperations)));
            ++i;
        }
        System.out.println("Starting " + threadCount + " worker threads...");
        long timeStart = System.currentTimeMillis();
        for (Thread thread : threads) {
            thread.start();
        }
        System.out.println("Running...");
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED!");
                System.exit(1);
            }
        }
        long testTime = System.currentTimeMillis() - timeStart;
        System.out.println("TOTAL: " + totalOperations.get() + " in " + testTime + "ms ~ " + (double)testTime / (double)totalOperations.get() + "ms per list operation...");
        System.out.println("---/// DONE ///---");
    }

    @Test
    public void test01() {
        totalOperations.set(0L);
        int threadCount = 10;
        int operCount = 1000;
        boolean logOperations = false;
        System.out.println("Creating barrier(" + threadCount + ")...");
        CyclicBarrier barrier = new CyclicBarrier(threadCount);
        ConcurrentList list = new ConcurrentList();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        System.out.println("Creating " + threadCount + " worker threads...");
        int i = 0;
        while (i < threadCount) {
            threads.add(new Thread(new Worker("W" + i, (List<Integer>)list, operCount, barrier, i, logOperations)));
            ++i;
        }
        System.out.println("Starting " + threadCount + " worker threads...");
        long timeStart = System.currentTimeMillis();
        for (Thread thread : threads) {
            thread.start();
        }
        System.out.println("Running...");
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED!");
                System.exit(1);
            }
        }
        long testTime = System.currentTimeMillis() - timeStart;
        System.out.println("TOTAL: " + totalOperations.get() + " in " + testTime + "ms ~ " + (double)testTime / (double)totalOperations.get() + "ms per list operation...");
        System.out.println("---/// DONE ///---");
    }

    public static void main(String[] args) {
        new Test00_ConcurrentList().test01();
    }

    private static class Worker
    implements Runnable {
        private String id;
        private List<Integer> list;
        private int operations;
        private Random random;
        private CyclicBarrier barrier;
        private boolean log;
        private long timeStart;
        private long listInvocations = 0L;

        public Worker(String id, List<Integer> list, int operations, CyclicBarrier barrier, long randomSeed, boolean log) {
            this.id = id;
            this.list = list;
            this.operations = operations;
            this.barrier = barrier;
            this.random = new Random(randomSeed);
            this.log = log;
        }

        public void log(int oper, String msg) {
            if (this.log) {
                this.logForce(oper, msg);
            }
        }

        public void logForce(int oper, String msg) {
            System.out.println("[" + this.id + "/" + oper + "] " + msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.log(0, "BARRIER AWAIT!");
                this.barrier.await();
            }
            catch (Exception e) {
                this.log(0, "INTERRUPTED!");
                return;
            }
            try {
                this.timeStart = System.currentTimeMillis();
                int i = 1;
                while (i <= this.operations) {
                    switch (this.random.nextInt(5)) {
                        case 0: {
                            int size = this.list.size();
                            if (size > 0) {
                                int index = this.random.nextInt(size);
                                this.log(i, "remove(" + index + ") = " + this.list.remove(index));
                                ++this.listInvocations;
                                break;
                            }
                        }
                        case 1: {
                            int size = this.list.size();
                            if (size > 0) {
                                int next = this.random.nextInt();
                                int index = this.random.nextInt(size);
                                this.log(i, "add(" + index + ", " + next + ")");
                                this.list.add(index, next);
                                ++this.listInvocations;
                                break;
                            }
                        }
                        case 2: {
                            int next = this.random.nextInt();
                            this.log(i, "add(" + next + ")");
                            this.list.add(next);
                            ++this.listInvocations;
                            break;
                        }
                        case 3: {
                            StringBuffer items = new StringBuffer();
                            this.log(i, "iterator()...");
                            Iterator<Integer> iterator = this.list.iterator();
                            ++this.listInvocations;
                            boolean first = true;
                            while (iterator.hasNext()) {
                                if (first) {
                                    first = false;
                                } else {
                                    items.append(",");
                                }
                                items.append(iterator.next());
                                ++this.listInvocations;
                            }
                            this.log(i, "iteration result: " + items.toString());
                            break;
                        }
                        case 4: {
                            StringBuffer items = new StringBuffer();
                            this.log(i, "for (Integer element : list)...");
                            boolean first = true;
                            for (Integer element : this.list) {
                                if (first) {
                                    first = false;
                                } else {
                                    items.append(",");
                                }
                                items.append(element);
                                ++this.listInvocations;
                            }
                            this.log(i, "for cycle result: " + items.toString());
                        }
                    }
                    ++i;
                }
                this.logForce(this.operations, "TIME: " + this.listInvocations + " synced operations in " + (System.currentTimeMillis() - this.timeStart) + "ms");
                totalOperations.addAndGet(this.listInvocations);
            }
            catch (Exception e) {
                List<Integer> list = this.list;
                synchronized (list) {
                    this.log(0, "EXCEPTION!");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

