/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.textures;

import cz.cuni.amis.clear2d.engine.textures.Subtexture;
import cz.cuni.amis.clear2d.engine.textures.TextureAtlas;
import cz.cuni.amis.clear2d.engine.textures.TextureAtlasXML;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class TextureAtlasResource
extends TextureAtlas {
    public TextureAtlasResource(InputStream atlasXMLInputStram, String atlasResourcePrefix) {
        this.load(atlasXMLInputStram, atlasResourcePrefix);
    }

    private void load(InputStream atlasXMLInputStram, String atlasResourcePrefix) {
        if (atlasXMLInputStram == null) {
            throw new RuntimeException("atlasXMLInputStram == null, invalid");
        }
        if (atlasResourcePrefix == null) {
            atlasResourcePrefix = "./";
        }
        TextureAtlasXML atlas = TextureAtlasXML.loadXML(atlasXMLInputStram);
        String resourcePath = String.valueOf(atlasResourcePrefix) + "/" + atlas.imagePath;
        try {
            this.setImage(ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(resourcePath)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource: " + atlas.imagePath + " => " + resourcePath);
        }
        for (TextureAtlasXML.SubtextureXML subtextureXML : atlas.subtextures) {
            Subtexture subtexture = new Subtexture(subtextureXML.name, this, subtextureXML.x, subtextureXML.y, subtextureXML.x + subtextureXML.width, subtextureXML.y + subtextureXML.height);
            this.textures.put(subtexture.name, subtexture);
        }
    }
}

