/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.clear2d.engine.textures;

import cz.cuni.amis.clear2d.Clear2D;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import java.awt.Graphics2D;

public class AnimatedTexture
implements IDrawable,
ITickable {
    public float framePeriod;
    public IDrawable[] frames;
    public int frame;
    public float nextFrame;
    public boolean animating = false;

    public AnimatedTexture(int fps, IDrawable ... frames) {
        this.framePeriod = 1.0f / (float)fps;
        this.frames = frames;
        this.frame = 0;
        this.nextFrame = this.framePeriod;
        this.start();
    }

    public void start() {
        Clear2D.engine.tickUpdate.add(this);
        this.animating = true;
    }

    public void stop() {
        Clear2D.engine.tickUpdate.add(this);
        this.animating = false;
    }

    @Override
    public void tick(C2DTime time) {
        if (this.frames == null) {
            return;
        }
        if (this.frames.length == 0) {
            return;
        }
        this.nextFrame -= time.game.delta;
        if (this.nextFrame < 0.0f) {
            this.frame = (this.frame + 1) % this.frames.length;
            this.nextFrame += this.framePeriod;
        }
    }

    @Override
    public void drawAt(Graphics2D g, float x, float y) {
        if (this.frames == null) {
            return;
        }
        if (this.frames.length == 0) {
            return;
        }
        if (this.frame > this.frames.length) {
            this.frame = 0;
        }
        this.frames[this.frame].drawAt(g, x, y);
    }

    @Override
    public int getWidth() {
        if (this.frames != null && this.frame >= 0 && this.frame < this.frames.length) {
            return this.frames[this.frame].getWidth();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.frames != null && this.frame >= 0 && this.frame < this.frames.length) {
            return this.frames[this.frame].getHeight();
        }
        return 0;
    }
}

