package cz.cuni.amis.clear2d.engine.controls;

public enum KeyState {

	/**
	 * Key is not pressed and was released for more than 1 frame.
	 */
	NONE(0),
	
	/**
	 * Key was just pressed.
	 */
	PRESSED(1),
	
	/**
	 * Key was pressed for more than 1 frame now.
	 */
	HOLD(2),
	
	/**
	 * Key was just released;
	 */
	RELEASED(3);
	
	public final int id;
	
	private KeyState(int id) {
		this.id = id;
	}
	
	/**
	 * [0] ~ on NONE switch to next[0]
	 * [1] ~ on PRESSED switch to next[1]
	 * [2] ~ on HOLD switch to next[2]
	 * [3] ~ on RELEASED switch to next[3]
	 */
	protected KeyState[] next;
	
	/**
	 * Combination requires "AND" (both keys must be in "state"), e.g., "A" requires "a+shift", what is the KeyState of "A" given two KeyStates for "a" and "shift"?
	 * [0] ~ combined with NONE     yields andCombination[0]
	 * [1] ~ combined with PRESSED  yields andCombination[1]
	 * [2] ~ combined with HOLD     yields andCombination[2]
	 * [3] ~ combined with RELEASED yields andCombination[3]
	 */
	protected KeyState[] andCombination;
	
	/**
	 * Combination requires "OR" (at least one key must be in "state"), e.g., "1" may be invoked via "keyboard 1" or "numpad 1", what is the KeyState of "1" given two KeyStates for "keyboard 1" and "numpad 1"?
	 * [0] ~ combined with NONE     yields andCombination[0]
	 * [1] ~ combined with PRESSED  yields andCombination[1]
	 * [2] ~ combined with HOLD     yields andCombination[2]
	 * [3] ~ combined with RELEASED yields andCombination[3]
	 */
	protected KeyState[] orCombination;
	
	static {
		KeyState.NONE.next     = new KeyState[] { KeyState.NONE,     KeyState.PRESSED, KeyState.PRESSED, KeyState.NONE     };
		KeyState.PRESSED.next  = new KeyState[] { KeyState.RELEASED, KeyState.HOLD,    KeyState.HOLD,    KeyState.RELEASED };
		KeyState.HOLD.next     = new KeyState[] { KeyState.RELEASED, KeyState.HOLD,    KeyState.HOLD,    KeyState.RELEASED };
		KeyState.RELEASED.next = new KeyState[] { KeyState.NONE,     KeyState.PRESSED, KeyState.PRESSED, KeyState.NONE     };
		
		KeyState.NONE.andCombination     = new KeyState[] { KeyState.NONE, KeyState.NONE,     KeyState.NONE,     KeyState.NONE     };
		KeyState.PRESSED.andCombination  = new KeyState[] { KeyState.NONE, KeyState.PRESSED,  KeyState.PRESSED,  KeyState.RELEASED };
		KeyState.HOLD.andCombination     = new KeyState[] { KeyState.NONE, KeyState.PRESSED,  KeyState.HOLD,     KeyState.RELEASED };
		KeyState.RELEASED.andCombination = new KeyState[] { KeyState.NONE, KeyState.RELEASED, KeyState.RELEASED, KeyState.RELEASED };
		
		KeyState.NONE.orCombination     = new KeyState[] { KeyState.NONE,     KeyState.PRESSED, KeyState.HOLD,  KeyState.RELEASED };
		KeyState.PRESSED.orCombination  = new KeyState[] { KeyState.PRESSED,  KeyState.PRESSED, KeyState.HOLD,  KeyState.PRESSED  };
		KeyState.HOLD.orCombination     = new KeyState[] { KeyState.HOLD,     KeyState.HOLD,    KeyState.HOLD,  KeyState.HOLD     };
		KeyState.RELEASED.orCombination = new KeyState[] { KeyState.RELEASED, KeyState.PRESSED, KeyState.HOLD,  KeyState.RELEASED };
	}
	
}
