/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public class LogFilter {
    private File source;
    private File destination;
    private Pattern[] accept;
    private Pattern[] remove;

    public LogFilter(File source, File destination, Pattern[] accept, Pattern[] remove) {
        this.source = source;
        this.destination = destination;
        this.accept = accept;
        this.remove = remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() throws IOException {
        try (FileReader fileReader = new FileReader(this.source);){
            BufferedReader reader = new BufferedReader(fileReader);
            try (FileWriter fileWriter = new FileWriter(this.destination);){
                PrintWriter writer = new PrintWriter(fileWriter);
                System.out.println("-= Log filtering =-");
                System.out.println("Source: " + this.source.getAbsolutePath());
                System.out.println("Destin: " + this.destination.getAbsolutePath());
                int lineCount = 0;
                while (reader.ready()) {
                    boolean next = false;
                    System.out.print(".");
                    if (++lineCount % 100 == 0) {
                        System.out.println();
                    }
                    String line = reader.readLine();
                    for (Pattern a : this.accept) {
                        if (!a.matcher(line).find()) continue;
                        writer.println(line);
                        next = true;
                        break;
                    }
                    if (next) continue;
                    for (Pattern r : this.remove) {
                        if (!r.matcher(line).find()) continue;
                        next = true;
                        break;
                    }
                    if (next) continue;
                    writer.println(line);
                }
                System.out.println();
                System.out.println("FINISHED");
            }
        }
    }
}

