/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.Const;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class FileAppender {
    private File file;
    private PrintWriter writer;

    public FileAppender(File file) {
        this.file = file;
    }

    public synchronized void append(String line) {
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter(new FileOutputStream(this.file, true));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open file for appending at: " + this.file.getAbsolutePath());
            }
        }
        this.writer.append(line);
        this.writer.append(Const.NEW_LINE);
        this.writer.flush();
    }

    public synchronized void appendIfNotExists(String line) {
        if (!this.file.exists()) {
            this.append(line);
        }
    }

    public synchronized void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writer = null;
        }
    }

    public void appendAndClose(String line) {
        this.append(line);
        this.close();
    }

    public void appendIfNotExistsAndClose(String line) {
        this.appendIfNotExists(line);
        this.close();
    }

    public static void appendToFile(File file, String line) {
        new FileAppender(file).appendAndClose(line);
    }

    public static void appendToFileIfNotExists(File file, String line) {
        new FileAppender(file).appendIfNotExistsAndClose(line);
    }
}

