/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.HashTriMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class WeakHashQuadMap<PRIMARY_KEY, SECONDARY_KEY, TERTIARY_KEY, QUATERNARY_KEY, ITEM>
extends WeakHashMap<PRIMARY_KEY, Map<SECONDARY_KEY, Map<TERTIARY_KEY, Map<QUATERNARY_KEY, ITEM>>>> {
    private int secondaryCapacity;
    private int tertiaryCapacity;
    private int quaternaryCapacity;

    public WeakHashQuadMap() {
        this.secondaryCapacity = 16;
        this.tertiaryCapacity = 16;
        this.quaternaryCapacity = 16;
    }

    public WeakHashQuadMap(int primaryCapacity, int secondaryCapacity, int tertiaryCapacity, int quaternaryCapacity) {
        super(primaryCapacity);
        this.secondaryCapacity = secondaryCapacity;
        this.tertiaryCapacity = tertiaryCapacity;
        this.quaternaryCapacity = quaternaryCapacity;
    }

    @Override
    public Map<SECONDARY_KEY, Map<TERTIARY_KEY, Map<QUATERNARY_KEY, ITEM>>> get(Object key) {
        Map result = (Map)super.get(key);
        if (result != null) {
            return result;
        }
        result = Collections.synchronizedMap(new HashTriMap(this.secondaryCapacity, this.tertiaryCapacity, this.quaternaryCapacity));
        super.put(key, result);
        return result;
    }

    public Map<TERTIARY_KEY, Map<QUATERNARY_KEY, ITEM>> get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        Map result = (Map)this.get(primaryKey).get(secondaryKey);
        if (result != null) {
            return result;
        }
        result = Collections.synchronizedMap(new HashMapMap(this.tertiaryCapacity, this.quaternaryCapacity));
        this.get(primaryKey).put(secondaryKey, result);
        return result;
    }

    public Map<QUATERNARY_KEY, ITEM> get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey) {
        Map<Object, Object> result = this.get(primaryKey, secondaryKey).get(tertiaryKey);
        if (result != null) {
            return result;
        }
        result = Collections.synchronizedMap(new HashMap(this.quaternaryCapacity));
        this.get(primaryKey, secondaryKey).put(tertiaryKey, result);
        return result;
    }

    public ITEM get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey, QUATERNARY_KEY quaternaryKey) {
        return this.get(primaryKey, secondaryKey, tertiaryKey).get(quaternaryKey);
    }

    public ITEM put(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey, QUATERNARY_KEY quaternaryKey, ITEM item) {
        return this.get(primaryKey, secondaryKey, tertiaryKey).put(quaternaryKey, item);
    }

    @Override
    public Map<SECONDARY_KEY, Map<TERTIARY_KEY, Map<QUATERNARY_KEY, ITEM>>> remove(Object key) {
        Map result = (Map)super.remove(key);
        if (result != null) {
            return result;
        }
        return Collections.synchronizedMap(new HashTriMap(this.secondaryCapacity, this.tertiaryCapacity, this.quaternaryCapacity));
    }

    public Map<TERTIARY_KEY, Map<QUATERNARY_KEY, ITEM>> remove2(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        Map result = (Map)this.get(primaryKey).remove(secondaryKey);
        if (result != null) {
            return result;
        }
        return Collections.synchronizedMap(new HashMapMap(this.tertiaryCapacity, this.quaternaryCapacity));
    }

    public Map<QUATERNARY_KEY, ITEM> remove(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey) {
        Map<QUATERNARY_KEY, ITEM> result = this.get(primaryKey, secondaryKey).remove(tertiaryKey);
        if (result != null) {
            return result;
        }
        return Collections.synchronizedMap(new HashMap(this.quaternaryCapacity));
    }

    public ITEM remove(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, TERTIARY_KEY tertiaryKey, QUATERNARY_KEY quaternaryKey) {
        return this.get(primaryKey, secondaryKey, tertiaryKey).remove(quaternaryKey);
    }
}

