/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HashMapMap<PRIMARY_KEY, SECONDARY_KEY, ITEM>
extends HashMap<PRIMARY_KEY, Map<SECONDARY_KEY, ITEM>> {
    private static final long serialVersionUID = -4541899270970246601L;
    int secondaryCapacity;

    public HashMapMap() {
        this.secondaryCapacity = 16;
    }

    public HashMapMap(int primaryCapacity, int secondaryCapacity) {
        super(primaryCapacity);
        this.secondaryCapacity = secondaryCapacity;
    }

    @Override
    public Map<SECONDARY_KEY, ITEM> get(Object primaryKey) {
        Map map = (Map)super.get(primaryKey);
        if (map != null) {
            return map;
        }
        map = Collections.synchronizedMap(new HashMap(this.secondaryCapacity));
        super.put(primaryKey, map);
        return map;
    }

    public ITEM get(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        return (ITEM)this.get(primaryKey).get(secondaryKey);
    }

    public ITEM put(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey, ITEM item) {
        return this.get(primaryKey).put(secondaryKey, item);
    }

    @Override
    public Map<SECONDARY_KEY, ITEM> remove(Object primaryKey) {
        Map map = (Map)super.remove(primaryKey);
        if (map != null) {
            return map;
        }
        return Collections.synchronizedMap(new HashMap(this.secondaryCapacity));
    }

    public ITEM remove2(PRIMARY_KEY primaryKey, SECONDARY_KEY secondaryKey) {
        return (ITEM)this.get(primaryKey).remove(secondaryKey);
    }
}

