/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicIntegerList {
    private List<AtomicIntegerArray> arrays = new ArrayList<AtomicIntegerArray>();
    private int capacityStep;
    private int size = 0;

    public AtomicIntegerList(int initialCapacity, int capacityStep) {
        this.capacityStep = capacityStep;
        if (initialCapacity > 0) {
            this.getArray(initialCapacity - 1);
        }
    }

    private int arrayIndex(int index) {
        return index / this.capacityStep;
    }

    private int trueIndex(int index) {
        return index - this.capacityStep * (index / this.capacityStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicIntegerArray getArray(int index) {
        List<AtomicIntegerArray> list;
        int arrayIndex = this.arrayIndex(index);
        if (this.size <= index) {
            list = this.arrays;
            synchronized (list) {
                if (this.size <= index) {
                    this.size = index + 1;
                }
            }
        }
        if (arrayIndex < this.arrays.size()) {
            return this.arrays.get(arrayIndex);
        }
        list = this.arrays;
        synchronized (list) {
            while (this.arrays.size() <= arrayIndex) {
                this.arrays.add(new AtomicIntegerArray(this.capacityStep));
            }
        }
        return this.arrays.get(arrayIndex);
    }

    public int addAndGet(int i, int delta) {
        return this.getArray(i).addAndGet(this.trueIndex(i), delta);
    }

    public boolean compareAndSet(int i, int expect, int update) {
        return this.getArray(i).compareAndSet(this.trueIndex(i), expect, update);
    }

    public int decrementAndGet(int i) {
        return this.getArray(i).decrementAndGet(this.trueIndex(i));
    }

    public int get(int i) {
        return this.getArray(i).get(this.trueIndex(i));
    }

    public int getAndAdd(int i, int delta) {
        return this.getArray(i).getAndAdd(this.trueIndex(i), delta);
    }

    public int getAndDecrement(int i) {
        return this.getArray(i).getAndDecrement(this.trueIndex(i));
    }

    public int getAndIncrement(int i) {
        return this.getArray(i).getAndIncrement(this.trueIndex(i));
    }

    public int getAndSet(int i, int newValue) {
        return this.getArray(i).getAndSet(this.trueIndex(i), newValue);
    }

    public int incrementAndGet(int i) {
        return this.getArray(i).incrementAndGet(this.trueIndex(i));
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.arrays.size() * this.capacityStep;
    }

    public void set(int i, int newValue) {
        this.getArray(i).set(this.trueIndex(i), newValue);
    }

    public boolean weakCompareAndSet(int i, int expect, int update) {
        return this.getArray(i).weakCompareAndSet(this.trueIndex(i), expect, update);
    }
}

