/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.io.Serializable;

public class FlagInteger
extends Flag<Integer>
implements Serializable {
    public FlagInteger() {
        super(0);
    }

    public FlagInteger(Integer initial) {
        super(initial);
    }

    public void increment(final int number) {
        this.inSync(new Flag.DoInSync<Integer>(){

            @Override
            public void execute(Integer flagValue) {
                this.setFlag(flagValue + number);
            }
        });
    }

    public void decrement(final int number) {
        this.inSync(new Flag.DoInSync<Integer>(){

            @Override
            public void execute(Integer flagValue) {
                this.setFlag(flagValue - number);
            }
        });
    }

    public static abstract class DoInSyncWithReason<T, R>
    extends Flag.DoInSync<T> {
        @Override
        protected boolean isImmutable() {
            return this.flag instanceof ImmutableFlag;
        }

        protected void setFlag(T value, R reason) {
            if (this.flag instanceof ImmutableFlag) {
                throw new UnsupportedOperationException("trying to set flag of the immutable flag!");
            }
            this.flag.value = value;
            this.flag.notifier.setValue(value);
            this.flag.listeners.notify(this.flag.notifier);
        }

        @Override
        protected T getFlag() {
            return this.flag.getFlag();
        }

        @Override
        public abstract void execute(T var1);

        public abstract void execute(T var1, R var2);
    }
}

