/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.BaseTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class Test09_ReadWriteLock
extends BaseTest {
    public static int bogus;
    public CountDownLatch latch;
    public static volatile int value;
    public AtomicBoolean alone = new AtomicBoolean(true);
    public ReadWriteLock lock = new ReentrantReadWriteLock(false);
    public Lock readLock = this.lock.readLock();
    public Lock writeLock = this.lock.readLock();
    private StringBuffer errors = new StringBuffer();
    private boolean failure;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(String error) {
        this.failure = true;
        StringBuffer stringBuffer = this.errors;
        synchronized (stringBuffer) {
            this.errors.append(error);
            this.errors.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int threads = 40;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            int jobs = 1000;
            int add = 1000;
            this.latch = new CountDownLatch(jobs);
            for (int i = 0; i < jobs; ++i) {
                executor.execute(new IncReadDecValueAsync(0, add));
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            log.info("Checking value, expecting 0 ...");
            if (value != 0) {
                this.testFailed("value == " + value + " != 0");
            }
            if (this.failure) {
                this.testFailed(this.errors.toString());
            }
            this.testOk();
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static void main(String[] args) {
        Test09_ReadWriteLock test = new Test09_ReadWriteLock();
        BaseTest.baseTestBeforeClass();
        test.beforeTest();
        test.test();
        test.afterTest();
    }

    static {
        value = 0;
    }

    public class IncReadDecValueAsync
    implements Runnable {
        private int from;
        private int to;

        public IncReadDecValueAsync(int from, int to) {
            this.from = from;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isAlone = false;
            for (int i = this.from; i < this.to; ++i) {
                Test09_ReadWriteLock.this.writeLock.lock();
                try {
                    isAlone = Test09_ReadWriteLock.this.alone.getAndSet(false);
                    if (!isAlone) {
                        Test09_ReadWriteLock.this.errors.append("Not alone!");
                    }
                    isAlone = Test09_ReadWriteLock.this.alone.getAndSet(true);
                    ++value;
                    if (isAlone) {
                        Test09_ReadWriteLock.this.errors.append("Is alone and should not be!");
                    }
                }
                finally {
                    Test09_ReadWriteLock.this.writeLock.unlock();
                }
                Test09_ReadWriteLock.this.readLock.lock();
                try {
                    ++bogus;
                }
                finally {
                    Test09_ReadWriteLock.this.readLock.unlock();
                }
                Test09_ReadWriteLock.this.writeLock.lock();
                try {
                    isAlone = Test09_ReadWriteLock.this.alone.getAndSet(false);
                    if (!isAlone) {
                        Test09_ReadWriteLock.this.errors.append("Not alone!");
                    }
                    --value;
                    isAlone = Test09_ReadWriteLock.this.alone.getAndSet(true);
                    if (!isAlone) continue;
                    Test09_ReadWriteLock.this.errors.append("Is alone and should not be!");
                    continue;
                }
                finally {
                    Test09_ReadWriteLock.this.writeLock.unlock();
                }
            }
            CountDownLatch countDownLatch = Test09_ReadWriteLock.this.latch;
            synchronized (countDownLatch) {
                Test09_ReadWriteLock.this.latch.countDown();
                log.info("Jobs remaining: " + Test09_ReadWriteLock.this.latch.getCount());
            }
        }
    }
}

