/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.IFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WaitForFlagChange<TYPE> {
    private IAccept<TYPE> accept;
    private IFlag<TYPE> flag;
    private Object latchAccessMutex = new Object();
    private Object mutex = new Object();
    private CountDownLatch latch = null;
    private boolean isResult = false;
    private TYPE result = null;

    public WaitForFlagChange(IFlag<TYPE> flag) {
        this.flag = flag;
        this.accept = new ListAccept();
    }

    public WaitForFlagChange(IFlag<TYPE> flag, IAccept<TYPE> waitingFor) {
        this.flag = flag;
        this.accept = waitingFor;
    }

    public WaitForFlagChange(IFlag<TYPE> flag, TYPE waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    public WaitForFlagChange(IFlag<TYPE> flag, TYPE[] waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    public WaitForFlagChange(IFlag<TYPE> flag, Collection<TYPE> waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    private boolean isDesiredValue(TYPE value) {
        return this.accept.accept(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE await() throws PogamutInterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.latchAccessMutex;
            synchronized (object2) {
                this.latch = new CountDownLatch(1);
            }
            Listener listener = new Listener(this.flag);
            if (this.isResult) {
                return this.result;
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException(e, (Object)this);
            }
            Object object3 = this.latchAccessMutex;
            synchronized (object3) {
                this.flag.removeListener(listener);
                this.latch = null;
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE await(long timeout, TimeUnit timeUnit) throws PogamutInterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.latchAccessMutex;
            synchronized (object2) {
                this.latch = new CountDownLatch(1);
            }
            Listener listener = new Listener(this.flag);
            if (this.isResult) {
                return this.result;
            }
            try {
                this.latch.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException(e, (Object)this);
            }
            Object object3 = this.latchAccessMutex;
            synchronized (object3) {
                this.flag.removeListener(listener);
                this.latch = null;
            }
            return this.result;
        }
    }

    private class Listener
    implements FlagListener<TYPE> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Listener(IFlag<TYPE> flag) {
            Object result;
            WaitForFlagChange.this.result = flag.getFlag();
            if (!(WaitForFlagChange.this.isResult = WaitForFlagChange.this.isDesiredValue(WaitForFlagChange.this.result))) {
                flag.addListener(this);
            }
            if (!WaitForFlagChange.this.isResult && WaitForFlagChange.this.isDesiredValue(result = flag.getFlag())) {
                WaitForFlagChange.this.isResult = true;
                WaitForFlagChange.this.result = result;
                flag.removeListener(this);
                Object object = WaitForFlagChange.this.latchAccessMutex;
                synchronized (object) {
                    if (WaitForFlagChange.this.latch != null) {
                        WaitForFlagChange.this.latch.countDown();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flagChanged(TYPE changedValue) {
            if (!WaitForFlagChange.this.isResult && WaitForFlagChange.this.isDesiredValue(changedValue)) {
                WaitForFlagChange.this.flag.removeListener(this);
                Object object = WaitForFlagChange.this.latchAccessMutex;
                synchronized (object) {
                    WaitForFlagChange.this.isResult = true;
                    WaitForFlagChange.this.result = changedValue;
                    if (WaitForFlagChange.this.latch != null) {
                        WaitForFlagChange.this.latch.countDown();
                    }
                }
            }
        }
    }

    private class ListAccept
    implements IAccept<TYPE> {
        private List<TYPE> waitingFor;

        public ListAccept(Collection<TYPE> list) {
            this.waitingFor = new ArrayList(list.size());
            this.waitingFor.addAll(list);
        }

        public ListAccept() {
            this.waitingFor = null;
        }

        public ListAccept(TYPE ... accept) {
            this.waitingFor = new ArrayList(accept.length);
            this.waitingFor.addAll(MyCollections.toList(accept));
        }

        @Override
        public boolean accept(TYPE flagValue) {
            if (this.waitingFor == null) {
                return true;
            }
            return this.waitingFor.contains(flagValue);
        }
    }

    public static interface IAccept<TYPE> {
        public boolean accept(TYPE var1);
    }
}

