/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.token;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;

public class Test01_Tokens
extends BaseTest {
    @Test
    public void test01_Equals() {
        Token token1 = Tokens.get((String)"ahoj");
        Token token2 = Tokens.get((String)"cau");
        Token token3 = Tokens.get((String)"ahoj");
        Token token4_1 = Tokens.get((String)"4");
        Token token5_1 = Tokens.get((String)"5");
        Token token4_2 = Tokens.get((long)4L);
        Token token5_2 = Tokens.get((long)5L);
        Assert.assertTrue((String)"token1 should be equal to itself", (boolean)token1.equals((Object)token1));
        Assert.assertTrue((String)"token1 should not be equal to null", (!token1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token2 should not be equal to token1", (!token1.equals((Object)token2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token2 should not be equal to token3", (!token2.equals((Object)token3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token1 should be equal to token3", (boolean)token1.equals((Object)token3));
        Assert.assertTrue((String)"token4_1 should be equal to token4_2", (boolean)token4_1.equals((Object)token4_2));
        Assert.assertTrue((String)"token5_1 should be equal to token5_2", (boolean)token5_1.equals((Object)token5_2));
        Assert.assertTrue((String)"token4_1 should not be equal to token5_1", (!token4_1.equals((Object)token5_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token4_1 should not be equal to token5_2", (!token4_1.equals((Object)token5_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should not be equal to token4_1", (!token5_1.equals((Object)token4_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should not be equal to token4_2", (!token5_1.equals((Object)token4_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token4_1 should not be equal to token1", (!token4_1.equals((Object)token1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should not beequal to token2", (!token5_1.equals((Object)token2) ? 1 : 0) != 0);
        this.testOk();
    }

    @Test
    public void test02_TokensInHashSet() {
        Token token1 = Tokens.get((String)"ahoj");
        Token token2 = Tokens.get((String)"cau");
        Token token3 = Tokens.get((String)"ahoj");
        Token token4_1 = Tokens.get((String)"4");
        Token token5_1 = Tokens.get((String)"5");
        Token token4_2 = Tokens.get((long)4L);
        Token token5_2 = Tokens.get((long)5L);
        HashSet<Token> setOfTokens = new HashSet<Token>();
        setOfTokens.add(token1);
        setOfTokens.add(token2);
        setOfTokens.add(token4_1);
        setOfTokens.add(token5_1);
        Assert.assertTrue((String)"Set should contain token1", (boolean)setOfTokens.contains(token1));
        Assert.assertTrue((String)"Set should contain token2", (boolean)setOfTokens.contains(token2));
        Assert.assertTrue((String)"Set should contain token3", (boolean)setOfTokens.contains(token3));
        Assert.assertTrue((String)"Set should contain token4_1", (boolean)setOfTokens.contains(token4_1));
        Assert.assertTrue((String)"Set should contain token4_2", (boolean)setOfTokens.contains(token4_2));
        Assert.assertTrue((String)"Set should contain token5_1", (boolean)setOfTokens.contains(token5_1));
        Assert.assertTrue((String)"Set should contain token5_2", (boolean)setOfTokens.contains(token5_2));
        setOfTokens.remove(token3);
        setOfTokens.remove(token4_2);
        Assert.assertTrue((String)"Set should NOT contain token1", (!setOfTokens.contains(token1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Set should still contain token2", (boolean)setOfTokens.contains(token2));
        Assert.assertTrue((String)"Set should NOT contain token4_1", (!setOfTokens.contains(token4_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Set should NOT contain token4_2", (!setOfTokens.contains(token4_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Set should still contain token5_1", (boolean)setOfTokens.contains(token5_1));
        Assert.assertTrue((String)"Set should still contain token5_2", (boolean)setOfTokens.contains(token5_2));
        this.testOk();
    }

    @Test
    public void test03_TokensInHashMapAsKeys() {
        Token token1 = Tokens.get((String)"ahoj");
        Token token2 = Tokens.get((String)"cau");
        Token token3 = Tokens.get((String)"ahoj");
        Token token4_1 = Tokens.get((String)"4");
        Token token5_1 = Tokens.get((String)"5");
        Token token4_2 = Tokens.get((long)4L);
        Token token5_2 = Tokens.get((long)5L);
        HashMap<Token, Integer> map = new HashMap<Token, Integer>();
        map.put(token1, 1);
        map.put(token2, 2);
        map.put(token4_1, 3);
        map.put(token5_1, 4);
        Assert.assertTrue((String)"token1 should be inside the map as a key", (boolean)map.containsKey(token1));
        Assert.assertTrue((String)"token2 should be inside the map as a key", (boolean)map.containsKey(token2));
        Assert.assertTrue((String)"token3 should be inside the map as a key", (boolean)map.containsKey(token3));
        Assert.assertTrue((String)"token4_1 should be inside the map as a key", (boolean)map.containsKey(token4_1));
        Assert.assertTrue((String)"token4_2 should be inside the map as a key", (boolean)map.containsKey(token4_2));
        Assert.assertTrue((String)"token5_1 should be inside the map as a key", (boolean)map.containsKey(token5_1));
        Assert.assertTrue((String)"token5_2 should be inside the map as a key", (boolean)map.containsKey(token5_2));
        Assert.assertTrue((String)"token1 should give the same number as token3", (map.get(token1) == map.get(token3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token1 should give different number than token2", (map.get(token1) != map.get(token2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token1 should give different number than token4_1", (map.get(token1) != map.get(token4_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token1 should give different number than token5_2", (map.get(token1) != map.get(token5_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token4_1 should give the same number as token4_2", (map.get(token4_1) == map.get(token4_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should give the same number as token5_2", (map.get(token5_1) == map.get(token5_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token4_1 should give different number than token5_1", (map.get(token4_1) != map.get(token5_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token4_1 should give different number than token5_2", (map.get(token4_1) != map.get(token5_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should give different number than token4_1", (map.get(token5_1) != map.get(token4_1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"token5_1 should give different number than token4_2", (map.get(token5_1) != map.get(token4_2) ? 1 : 0) != 0);
        this.testOk();
    }

    public static void main(String[] args) {
        Test01_Tokens test = new Test01_Tokens();
        test.test01_Equals();
        test.test02_TokensInHashSet();
        test.test03_TokensInHashMapAsKeys();
    }
}

