/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.concurrency.AtomicIntegerList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class Test06_AtomicIntegerList
extends BaseTest {
    public static AtomicIntegerList list = new AtomicIntegerList(0, 50);
    public static CountDownLatch latch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int threads = 40;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            int i;
            int jobs = 1000;
            int add = 1000;
            latch = new CountDownLatch(jobs);
            for (i = 0; i < jobs; ++i) {
                executor.execute(new IncValueAsync(0, add));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            log.info("Checking list, expecing all 0...");
            for (i = 0; i < add; ++i) {
                if (list.get(i) == 0) continue;
                this.testFailed("List[" + i + "] = " + list.get(i) + " != 0 !!! AtomicIntegerList has concurrency issues.");
            }
            this.testOk();
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static class IncValueAsync
    implements Runnable {
        private int from;
        private int to;

        public IncValueAsync(int from, int to) {
            this.from = from;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            for (i = this.from; i < this.to; ++i) {
                list.addAndGet(i, 1);
            }
            for (i = this.from; i < this.to; ++i) {
                list.addAndGet(i, -1);
            }
            CountDownLatch countDownLatch = latch;
            synchronized (countDownLatch) {
                latch.countDown();
                System.out.println("Jobs remaining: " + latch.getCount());
            }
        }
    }
}

