/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.BaseTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class Test05_AtomicInc
extends BaseTest {
    public static Object valueMutex = new Object();
    public static int value;
    public static AtomicInteger atomicValue;
    public static CountDownLatch latch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicInt() {
        value = 0;
        atomicValue = new AtomicInteger(0);
        int threads = 40;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            int total = 0;
            int jobs = 1000;
            int add = 1000;
            latch = new CountDownLatch(jobs);
            for (int i = 0; i < jobs; ++i) {
                total += add;
                executor.execute(new IncValueAtomicInt(add));
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            log.info("Expected 0, reached " + atomicValue.get());
            if (0 != atomicValue.get()) {
                log.warning("atomicInteger.addAndGet(1) is not atomic operation !!!");
            }
            this.testOk();
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static class IncValueAtomicInt
    implements Runnable {
        private int add;

        public IncValueAtomicInt(int add) {
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.add > 0) {
                atomicValue.addAndGet(1);
                atomicValue.addAndGet(-1);
                --this.add;
                if (this.add % 100 != 0) continue;
                Thread.yield();
            }
            CountDownLatch countDownLatch = latch;
            synchronized (countDownLatch) {
                latch.countDown();
            }
            System.out.println("Jobs remaining: " + latch.getCount());
        }
    }

    public static class IncValueSync
    implements Runnable {
        private int add;

        public IncValueSync(int add) {
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (this.add > 0) {
                object = valueMutex;
                synchronized (object) {
                    ++value;
                }
                object = valueMutex;
                synchronized (object) {
                    --value;
                }
                --this.add;
                if (this.add % 100 != 0) continue;
                Thread.yield();
            }
            object = latch;
            synchronized (object) {
                latch.countDown();
            }
            System.out.println("Jobs remaining: " + latch.getCount());
        }
    }

    public static class IncValueAsync
    implements Runnable {
        private int add;

        public IncValueAsync(int add) {
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.add > 0) {
                ++value;
                --value;
                --this.add;
                if (this.add % 100 != 0) continue;
                Thread.yield();
            }
            CountDownLatch countDownLatch = latch;
            synchronized (countDownLatch) {
                latch.countDown();
            }
            System.out.println("Jobs remaining: " + latch.getCount());
        }
    }
}

