/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListenerMock;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class Test02_RaceConditions {
    @Test
    public void test01() {
        System.out.println("Testing racing conditions for the flag...");
        final Flag flag = new Flag((Object)true);
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch end = new CountDownLatch(2);
        Thread one = new Thread(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.out.println("Thread 1: start");
                for (int i = 0; i < 100; ++i) {
                    boolean value = i % 2 == 0;
                    System.out.println("Thread 1: setting flag to " + value);
                    flag.setFlag((Object)value);
                    Thread.yield();
                }
                end.countDown();
            }
        });
        Thread two = new Thread(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.out.println("Thread 2: start");
                for (int i = 0; i < 100; ++i) {
                    boolean value = i % 2 == 0;
                    System.out.println("Thread 2: setting flag to " + value);
                    flag.setFlag((Object)value);
                    Thread.yield();
                }
                end.countDown();
            }
        });
        one.start();
        two.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        flag.freeze();
        System.out.println("flag freezed...");
        FlagListenerMock<Boolean> testListener = new FlagListenerMock<Boolean>();
        flag.addListener(testListener);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        flag.setFlag((Object)((Boolean)flag.getFlag() == false ? 1 : 0));
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e1) {
            throw new PogamutInterruptedException((Throwable)e1, (Object)this);
        }
        testListener.checkValuesInOrder("TestListener", new Boolean[0]);
        System.out.println("flag was not changed while freezed, good!");
        flag.removeListener(testListener);
        System.out.println("flag defreezed...");
        flag.defreeze();
        try {
            end.await();
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
        System.out.println("---/// TEST OK ///---");
    }
}

