/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentFilter;
import cz.cuni.amis.experiments.IExperimentRunner;
import cz.cuni.amis.experiments.IExperimentSuite;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.impl.AbstractExperimentSuiteRunner;
import cz.cuni.amis.experiments.impl.DecoratedLogCentral;
import cz.cuni.amis.experiments.impl.LoggingHeaders;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class SingleThreadExperimentSuiteRunner<EXPERIMENT_TYPE extends IExperiment>
extends AbstractExperimentSuiteRunner<EXPERIMENT_TYPE> {
    private final Logger logger = Logger.getLogger(SingleThreadExperimentSuiteRunner.class);
    private IExperimentRunner<EXPERIMENT_TYPE> runner;

    public SingleThreadExperimentSuiteRunner(IExperimentRunner<EXPERIMENT_TYPE> runner, ILogCentral logCentral) {
        super(logCentral);
        this.runner = runner;
    }

    @Override
    protected List<IExperimentRunner<EXPERIMENT_TYPE>> getAllRunners() {
        return Collections.singletonList(this.runner);
    }

    @Override
    protected void runExperimentSuiteInternal(IExperimentSuite<EXPERIMENT_TYPE> suite, int startExperiment, int stopAfter, IExperimentFilter<EXPERIMENT_TYPE> filter) {
        this.logger.info((Object)("Starting suite " + suite.getName() + " start experiment: " + startExperiment + " stopAfter:" + stopAfter + " filter:" + filter));
        this.logger.info((Object)"Running beforeAllExperiments()");
        suite.beforeAllExperiments();
        int numExperimentsRun = 0;
        LoggingHeaders additionalLoggingHeaders = new LoggingHeaders("SuiteName", "ID");
        List<EXPERIMENT_TYPE> experiments = suite.getExperiments();
        for (int i = startExperiment; i < experiments.size() && (stopAfter <= 0 || numExperimentsRun < stopAfter); ++i) {
            IExperiment experiment = (IExperiment)experiments.get(i);
            if (filter == null || filter.accept(experiment)) {
                suite.beforeExperiment(experiment);
                this.logger.info((Object)("Running experiment no.: " + i + " : " + experiment.getDescription()));
                List<Object> additionalLoggingValues = Arrays.asList(suite.getName(), i);
                DecoratedLogCentral decoratedCentral = new DecoratedLogCentral(this.logCentral, (ILoggingHeaders)additionalLoggingHeaders, additionalLoggingValues);
                this.runSingleExperiment(this.runner, experiment, decoratedCentral);
                suite.afterExperiment(experiment);
                System.gc();
                ++numExperimentsRun;
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Experiment no." + i + " was filtered out."));
        }
        this.logger.info((Object)"All exepriments done, running afterAllExperiments().");
        suite.afterAllExperiments();
        this.logger.info((Object)("Suite " + suite.getName() + " finished"));
    }
}

