/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.impl.AbstractLoggingHeaders;
import cz.cuni.amis.experiments.impl.LoggingHeaders;
import cz.cuni.amis.utils.collections.ListConcatenation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoggingHeadersConcatenation
extends AbstractLoggingHeaders {
    private List<ILoggingHeaders> headersList;
    List<String> columnNames;

    public static ILoggingHeaders concatenate(ILoggingHeaders ... headersSet) {
        return LoggingHeadersConcatenation.concatenate(Arrays.asList(headersSet));
    }

    public static ILoggingHeaders concatenate(List<ILoggingHeaders> headersSet) {
        if (headersSet.isEmpty()) {
            return LoggingHeaders.EMPTY_LOGGING_HEADERS;
        }
        ArrayList<ILoggingHeaders> nonEmptyBasicHeaders = new ArrayList<ILoggingHeaders>(headersSet.size());
        for (ILoggingHeaders headers : headersSet) {
            if (headers instanceof LoggingHeadersConcatenation) {
                nonEmptyBasicHeaders.addAll(((LoggingHeadersConcatenation)headers).headersList);
                continue;
            }
            if (headers.getColumnCount() <= 0) continue;
            nonEmptyBasicHeaders.add(headers);
        }
        if (nonEmptyBasicHeaders.size() == 1) {
            return (ILoggingHeaders)nonEmptyBasicHeaders.get(0);
        }
        return new LoggingHeadersConcatenation(nonEmptyBasicHeaders);
    }

    public LoggingHeadersConcatenation(ILoggingHeaders ... headersList) {
        this(Arrays.asList(headersList));
    }

    public LoggingHeadersConcatenation(List<ILoggingHeaders> headersList) {
        this.headersList = headersList;
        ArrayList<List<String>> columnNamesLists = new ArrayList<List<String>>();
        for (ILoggingHeaders headers : headersList) {
            columnNamesLists.add(headers.getColumnNames());
        }
        this.columnNames = ListConcatenation.concatenate(columnNamesLists);
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }
}

