/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ELogType;
import cz.cuni.amis.experiments.IBareLoggingOutput;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.ILogIdentifier;
import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.impl.LoggingHeadersConcatenation;
import cz.cuni.amis.experiments.impl.LoggingOutputDecorator;
import java.util.Arrays;
import java.util.List;

public class DecoratedLogCentral
implements ILogCentral {
    private ILogCentral original;
    private ILoggingHeaders headersToPrepend;
    private List<Object> dataToPrepend;

    public DecoratedLogCentral(ILogCentral original, ILoggingHeaders headersToPrepend, Object ... dataToPrepend) {
        this(original, headersToPrepend, Arrays.asList(dataToPrepend));
    }

    public DecoratedLogCentral(ILogCentral original, ILoggingHeaders headersToPrepend, List<Object> dataToPrepend) {
        if (headersToPrepend.getColumnCount() != dataToPrepend.size()) {
            throw new IllegalArgumentException("Headers must have same size as data.");
        }
        this.original = original;
        this.headersToPrepend = headersToPrepend;
        this.dataToPrepend = dataToPrepend;
    }

    @Override
    public void close() {
        this.original.close();
    }

    @Override
    public void flush() {
        this.original.flush();
    }

    @Override
    public void init() {
        this.original.init();
    }

    @Override
    public void releaseLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor) {
        this.original.releaseLoggingOutput(identifier, logType, requestor);
    }

    @Override
    public IBareLoggingOutput requestLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor, ILoggingHeaders ... loggingHeaders) {
        ILoggingHeaders combinedHeaders = LoggingHeadersConcatenation.concatenate(this.headersToPrepend, LoggingHeadersConcatenation.concatenate(loggingHeaders));
        IBareLoggingOutput undecoratedOutput = this.original.requestLoggingOutput(identifier, logType, requestor, combinedHeaders);
        return new LoggingOutputDecorator(undecoratedOutput, this.dataToPrepend);
    }
}

