/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.IValueConverter;
import cz.cuni.amis.experiments.impl.AbstractLoggingOutput;
import cz.cuni.amis.experiments.impl.DefaultValueConverter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CSVLoggingOutput
extends AbstractLoggingOutput {
    private File targetFile;
    private FileWriter writer;
    private boolean append;
    protected String fieldDelimiter = ",";
    protected String lineDelimiter = "\r\n";
    protected String quote = "\"";
    private IValueConverter valueConverter;
    private boolean writtenSomethingOnCurrentLine = false;

    public CSVLoggingOutput(File targetFile) {
        this(targetFile, new DefaultValueConverter());
    }

    public CSVLoggingOutput(File targetFile, boolean append) {
        this(targetFile, new DefaultValueConverter(), false);
    }

    public CSVLoggingOutput(File targetFile, IValueConverter valueConverter) {
        this(targetFile, valueConverter, false);
    }

    public CSVLoggingOutput(File targetFile, IValueConverter valueConverter, boolean append) {
        this.targetFile = targetFile;
        this.valueConverter = valueConverter;
        this.append = append;
    }

    @Override
    protected void closeInternal() throws IOException {
        this.writer.close();
    }

    protected void writeField(String value) throws IOException {
        if (this.writtenSomethingOnCurrentLine) {
            this.writer.write(this.fieldDelimiter);
        } else {
            this.writtenSomethingOnCurrentLine = true;
        }
        this.writer.append(this.quote).append(value.replace(this.quote, this.quote + this.quote)).append(this.quote);
    }

    protected void endLine() throws IOException {
        this.writer.write(this.lineDelimiter);
        this.writer.flush();
        this.writtenSomethingOnCurrentLine = false;
    }

    @Override
    public void init(ILoggingHeaders headers) throws IOException {
        super.init(headers);
        this.writer = new FileWriter(this.targetFile, this.append);
        if (!this.append) {
            for (String header : headers.getColumnNames()) {
                this.writeField(header);
            }
        }
        this.endLine();
    }

    @Override
    protected void logDataInternal(List<Object> data) throws IOException {
        for (Object field : data) {
            this.writeField(this.valueConverter.valueToString(field));
        }
        this.endLine();
    }

    @Override
    protected void flushInternal() throws IOException {
        this.writer.flush();
    }
}

