/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl.metrics;

/**
 * Thread safe variant of {@link IncrementalMetric}
 * @author Martin Cerny
 */
public class SynchronizedIncrementalMetric extends IncrementalMetric{


    public SynchronizedIncrementalMetric(String name) {
        super(name);
    }
    
    public SynchronizedIncrementalMetric(String name, long initialValue) {
        super(name, initialValue);
    }

    @Override
    public synchronized void increment() {
        super.increment();
    }

    @Override
    public synchronized void increment(long amount) {
        super.increment(amount);
    }

    @Override
    public synchronized Long getValue() {
        return super.getValue();
    }

    @Override
    public synchronized void reset() {
        super.reset();
    }

    @Override
    public synchronized void stopMeasurement() {
        super.stopMeasurement();
    }
    
    


    
}
