/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl.metrics;

/**
 * 
 * @author Martin Cerny
 */
public class IncrementalMetric extends AbstractMetric{

    private long count;

    public IncrementalMetric(String name) {
        this(name,0);
    }
    
    public IncrementalMetric(String name, long initialValue) {
        super(name);
        count = initialValue;
    }

    @Override
    public Long getValue() {
        return count;
    }
    
    public void increment(){
        if(!active){
            return;
        }
        count++;
    }
    
    public void increment(long amount){
        if(!active){
            return;
        }
        count += amount;
    }

    @Override
    public void reset() {
        super.reset();
        count = 0;
    }

    
}
