/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.IBareLoggingOutput;
import cz.cuni.amis.utils.collections.ListConcatenation;
import java.util.ArrayList;
import java.util.List;

/**
 * A decorator that adds fixed  fields to the beginning of each log row
 * @author Martin Cerny
 */
public class LoggingOutputDecorator extends AbstractBareLoggingOutput {
    private IBareLoggingOutput original;
    private List<Object> dataToPrepend;

    public LoggingOutputDecorator(IBareLoggingOutput original, List<Object> dataToPrepend) {
        this.original = original;
        this.dataToPrepend = new ArrayList<Object>(dataToPrepend);
    }
    

    @Override
    public void logData(List<Object> data) {
        original.logData(new ListConcatenation<Object>(dataToPrepend, data));                
    }
    
    
    
}
