/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.utils.collections.ListConcatenation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public class LoggingHeadersConcatenation extends AbstractLoggingHeaders{

    public static  ILoggingHeaders concatenate(ILoggingHeaders ... headersSet){
        return concatenate(Arrays.asList(headersSet));
    }

    /**
     *
     * Concatenates headers into the most simple form. 
     * <ul> <li>Empty lists are ommitted</li> 
     * <li>If there is only one non-empty header, the header is
     * returned, instead of concatenation</li> 
     * <li>If there is another
     * LoggingHeadersConcatenation among parameters, it is expanded and its components are
     * taken directly </li> </ul>
     *
     * @param headersSet
     * @return
     */
    public static  ILoggingHeaders concatenate(List<ILoggingHeaders> headersSet){
        if(headersSet.isEmpty()){
            return LoggingHeaders.EMPTY_LOGGING_HEADERS;
        } else {
            List<ILoggingHeaders> nonEmptyBasicHeaders = new ArrayList<ILoggingHeaders>(headersSet.size());
            for (ILoggingHeaders headers : headersSet) {
                if(headers instanceof LoggingHeadersConcatenation){
                    nonEmptyBasicHeaders.addAll(((LoggingHeadersConcatenation)headers).headersList);
                } else {
                    if(headers.getColumnCount() > 0 ){
                        nonEmptyBasicHeaders.add(headers);
                    }
                }
            }

            if (nonEmptyBasicHeaders.size() == 1) {
                return nonEmptyBasicHeaders.get(0);
            } else {
                return new LoggingHeadersConcatenation(nonEmptyBasicHeaders);
            }
        }
    }
    
    private List<ILoggingHeaders> headersList;
    List<String> columnNames;
    
    public LoggingHeadersConcatenation(ILoggingHeaders ... headersList) {
        this (Arrays.asList(headersList));
    }

        
    public LoggingHeadersConcatenation(List<ILoggingHeaders> headersList) {
        this.headersList = headersList;
        List<List<String>> columnNamesLists = new ArrayList<List<String>>();
        for(ILoggingHeaders headers : headersList){
            columnNamesLists.add(headers.getColumnNames());
        }
        columnNames = ListConcatenation.concatenate(columnNamesLists);
    }
    
    
    

    

    @Override
    public List<String> getColumnNames() {
        return columnNames;
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }
    
    
    
}
