/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ILoggingHeaders;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public class LoggingHeaders extends AbstractLoggingHeaders {
    private List<String> columnNames;

    public static final LoggingHeaders EMPTY_LOGGING_HEADERS = new LoggingHeaders();
    
    public LoggingHeaders(String ... columnNames) {
        this(Arrays.asList(columnNames));
    }

    public LoggingHeaders(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public List<String> getColumnNames() {
        return columnNames;
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    

    
    
}
