/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.*;
import java.util.Arrays;
import java.util.List;

/**
 * A log central that decorates the logs it provides.
 * @author Martin Cerny
 */
public class DecoratedLogCentral implements ILogCentral{
    private ILogCentral original;
    
    private ILoggingHeaders headersToPrepend;
    private List<Object> dataToPrepend;

    public DecoratedLogCentral(ILogCentral original, ILoggingHeaders headersToPrepend, Object ... dataToPrepend) {
        this(original, headersToPrepend, Arrays.asList(dataToPrepend));
    }

    public DecoratedLogCentral(ILogCentral original, ILoggingHeaders headersToPrepend, List<Object> dataToPrepend) {
        if(headersToPrepend.getColumnCount() != dataToPrepend.size()){
            throw new IllegalArgumentException("Headers must have same size as data.");
        }
        this.original = original;
        this.headersToPrepend = headersToPrepend;
        this.dataToPrepend = dataToPrepend;
    }

    @Override
    public void close() {
        original.close();
    }

    @Override
    public void flush() {
        original.flush();
    }

    @Override
    public void init() {
        original.init();
    }

    @Override
    public void releaseLoggingOutput(ILogIdentifier identifier,ELogType logType, Object requestor) {
        original.releaseLoggingOutput(identifier, logType, requestor);
    }

    @Override
    public IBareLoggingOutput requestLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor, ILoggingHeaders ... loggingHeaders) {
        ILoggingHeaders combinedHeaders = LoggingHeadersConcatenation.concatenate(headersToPrepend,  LoggingHeadersConcatenation.concatenate(loggingHeaders));
        IBareLoggingOutput undecoratedOutput = original.requestLoggingOutput(identifier, logType, requestor, combinedHeaders);
        return new LoggingOutputDecorator(undecoratedOutput, dataToPrepend);
    }
    
    
}
