/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.ILogIdentifier;

/**
 * Log identifier based on a class of logging object and log type.
 * @author Martin Cerny
 */
public class ClassLogIdentifier implements ILogIdentifier{

    private Class clazz;

    public ClassLogIdentifier(Class clazz) {
        this.clazz = clazz;
    }
    
    @Override
    public String getLogName() {
        return clazz.getSimpleName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final ClassLogIdentifier other = (ClassLogIdentifier) obj;
        if (this.clazz != other.clazz && (this.clazz == null || !this.clazz.equals(other.clazz))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "ClassLogIdentifier{" + clazz.getName() + '}';
    }

    
    
}
