/*
 * Copyright (C) 2013 Martin Cerny
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

/**
 *
 * @author Martin Cerny
 */
public interface ILogCentral {
    /**
     * Prepares the log central for use
     */
    void init();
    
    /**
     * Flushes all the data not yet sent to the output devices
     */
    void flush();
    
    /**
     * Request a logging output for given log identifier. If this method is called multiple times
     * for the same requestor, it still counts as one usage.
     * @param identifier
     * @param requestor the object who requests the log. The same object should then be used to call {@link #releaseLoggingOutput(cz.cuni.amis.experiments.ILogIdentifier, java.lang.Object) }
     * @param loggingHeaders the headers of fields to be logged. Calls with the same identifier should provide the same headers, otherwise an error might be thrown
     * @return 
     */
    IBareLoggingOutput requestLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor, ILoggingHeaders ... loggingHeaders);

    /**
     * Notify the central that given object no longer uses a logging output. The first call
     * to this method for a given identifier and requester may close the logging output, no matter
     * how many times {@link #requestLoggingOutput(cz.cuni.amis.experiments.ILogIdentifier, java.lang.Object) }
     * was called.
     * @param identifier
     * @param requestor 
     */
    void releaseLoggingOutput(ILogIdentifier identifier, ELogType logType, Object requestor);
    
    /**
     * Releases all resources associated with this log central.
     */
    void close();
}
