/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

import java.util.List;

/**
 * Interface for classes that represent a suite of experiments.
 * Defines a few useful callback functions.
 * @author Martin Cerny
 */
public interface IExperimentSuite<EXPERIMENT_TYPE extends IExperiment> {
    public List<EXPERIMENT_TYPE> getExperiments();
    public void beforeAllExperiments();
    public void afterAllExperiments();
    public void beforeExperiment(EXPERIMENT_TYPE experiment);
    public void afterExperiment(EXPERIMENT_TYPE experiment);
    
    /**
     * Get the name of the suit for logging purposes.
     */
    public String getName();
}
