/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;

import java.util.List;

/**
 * Interface for all classes that may run experiments. 
 * @author Martin Cerny
 */
public interface IExperimentRunner<EXPERIMENT_TYPE extends IExperiment> {
    /**
     * Called before the first experiment is executed on this runner. Runner should alloccate
     * any neccessary resources right there
     */
    void init();
    
    /**
     * Run a single experiment. Only one experiment may be executed at a given time
     * with a single runner instance, otherwise the behaviour is unspecified. This
     * method should block until the experiment is finished.
     * @param experiment
     * @return 
     */
    EExperimentRunResult runExperiment(EXPERIMENT_TYPE experiment, ILogCentral logCentral);
    
    /**
     * Called after last experiment is executed on this runner. Any resources allocated in {@link #init() }
     * should be released here.
     */
    void shutdown();
}
