/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.experiments;


import java.util.List;


/**
 * Interface that represents an experiment. An experiment is an object intended for single use. Reuse of the same experiment
 * for multiple runs may fail.
 * @author Martin Cerny
 */
public interface IExperiment {
        
    ILoggingHeaders getExperimentParametersHeaders();
    
    List<Object> getExperimentParameters();
    
    
    /**
     * Short description of the experiment for logging purposes
     * @return 
     */
    public String getDescription();
    
    public long getTimeout();
}
