/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl.metrics;

import cz.cuni.amis.experiments.impl.metrics.AbstractMetric;

public class IntegerAverageMetric
extends AbstractMetric {
    long total;
    int count;
    double noSamplesValue;

    public IntegerAverageMetric(String name, double noSamplesValue) {
        super(name);
        this.noSamplesValue = noSamplesValue;
    }

    public IntegerAverageMetric(String name) {
        this(name, Double.NaN);
    }

    public void addSample(long value) {
        if (!this.active) {
            return;
        }
        this.total += value;
        ++this.count;
    }

    @Override
    public Double getValue() {
        if (this.count == 0) {
            return this.noSamplesValue;
        }
        return (double)this.total / (double)this.count;
    }

    @Override
    public void reset() {
        super.reset();
        this.total = 0L;
        this.count = 0;
    }
}

