/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl.metrics;

import cz.cuni.amis.experiments.impl.metrics.AbstractMetric;

public class DoubleAverageMetric
extends AbstractMetric {
    double total;
    int count;
    double noSamplesValue;

    public DoubleAverageMetric(String name, double noSamplesValue) {
        super(name);
        this.noSamplesValue = noSamplesValue;
    }

    public DoubleAverageMetric(String name) {
        this(name, Double.NaN);
    }

    public void addSample(double value) {
        if (!this.active) {
            return;
        }
        this.total += value;
        ++this.count;
    }

    @Override
    public Double getValue() {
        if (this.count == 0) {
            return this.noSamplesValue;
        }
        return this.total / (double)this.count;
    }

    @Override
    public void reset() {
        super.reset();
        this.count = 0;
        this.total = 0.0;
    }
}

