/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl;

import cz.cuni.amis.experiments.EExperimentRunResult;
import cz.cuni.amis.experiments.ELogType;
import cz.cuni.amis.experiments.IBareLoggingOutput;
import cz.cuni.amis.experiments.IExperiment;
import cz.cuni.amis.experiments.IExperimentRunner;
import cz.cuni.amis.experiments.ILogCentral;
import cz.cuni.amis.experiments.ILogDataProvider;
import cz.cuni.amis.experiments.ILoggingHeaders;
import cz.cuni.amis.experiments.impl.DecoratedLogCentral;
import cz.cuni.amis.experiments.impl.LoggingHeaders;
import cz.cuni.amis.utils.flag.Flag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractExperimentRunner<EXPERIMENT_TYPE extends IExperiment>
implements IExperimentRunner<EXPERIMENT_TYPE> {
    private final Logger logger = Logger.getLogger(AbstractExperimentRunner.class);
    private LoggingHeaders executionStatusHeaders = new LoggingHeaders("startTime", "duration", "status");

    @Override
    public void shutdown() {
    }

    protected void prepareExperiment(EXPERIMENT_TYPE experiment) {
    }

    @Override
    public final EExperimentRunResult runExperiment(EXPERIMENT_TYPE experiment, ILogCentral logCentral) {
        DecoratedLogCentral parametersDecoratedCentral = new DecoratedLogCentral(logCentral, experiment.getExperimentParametersHeaders(), experiment.getExperimentParameters());
        this.prepareExperiment(experiment);
        for (ILogDataProvider provider : this.getAllLogProviders(experiment)) {
            ILoggingHeaders headers = provider.getRuntimeLoggingHeaders();
            if (headers == null || headers.getColumnCount() <= 0) continue;
            IBareLoggingOutput runtimeLoggingOutput = parametersDecoratedCentral.requestLoggingOutput(provider.getIdentifier(), ELogType.RUNTIME, provider, headers);
            provider.setRuntimeLoggingOutput(runtimeLoggingOutput);
        }
        ExperimentProcess experimentProcess = new ExperimentProcess(this, experiment);
        long startTime = System.currentTimeMillis();
        new Thread(experimentProcess).start();
        if (experiment.getTimeout() > 0L) {
            experimentProcess.getFinished().waitFor(experiment.getTimeout(), (Object[])new Boolean[]{true});
        } else {
            experimentProcess.getFinished().waitFor((Object[])new Boolean[]{true});
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        EExperimentRunResult result = (Boolean)experimentProcess.getFinished().getFlag() != false ? experimentProcess.getResult() : EExperimentRunResult.TIMEOUT;
        List<Object> executionStatusData = Arrays.asList(new Object[]{startTime, duration, result});
        for (ILogDataProvider provider : this.getAllLogProviders(experiment)) {
            ILoggingHeaders headers = provider.getRuntimeLoggingHeaders();
            if (headers != null && headers.getColumnCount() > 0) {
                parametersDecoratedCentral.releaseLoggingOutput(provider.getIdentifier(), ELogType.RUNTIME, provider);
            }
            IBareLoggingOutput perExperimentOutput = parametersDecoratedCentral.requestLoggingOutput(provider.getIdentifier(), ELogType.PER_EXPERIMENT, this, this.executionStatusHeaders, this.getAdditionalLoggingHeaders(experiment, provider), provider.getPerExperimentLoggingHeaders());
            perExperimentOutput.logData(executionStatusData, this.getAdditionalLoggingDataValues(experiment, provider), provider.getPerExperimentLoggingData());
            parametersDecoratedCentral.releaseLoggingOutput(provider.getIdentifier(), ELogType.PER_EXPERIMENT, this);
        }
        return result;
    }

    protected abstract List<ILogDataProvider> getAllLogProviders(EXPERIMENT_TYPE var1);

    protected ILoggingHeaders getAdditionalLoggingHeaders(EXPERIMENT_TYPE experiment, ILogDataProvider provider) {
        return LoggingHeaders.EMPTY_LOGGING_HEADERS;
    }

    protected List<Object> getAdditionalLoggingDataValues(EXPERIMENT_TYPE experiment, ILogDataProvider provider) {
        return Collections.EMPTY_LIST;
    }

    protected abstract EExperimentRunResult runExperimentInternal(EXPERIMENT_TYPE var1);

    @Override
    public void init() {
    }

    private static class ExperimentProcess
    implements Runnable {
        private EXPERIMENT_TYPE experiment;
        private Flag<Boolean> finished;
        private EExperimentRunResult result;
        final /* synthetic */ AbstractExperimentRunner this$0;

        public ExperimentProcess(EXPERIMENT_TYPE experiment) {
            this.this$0 = var1_1;
            this.experiment = experiment;
            this.finished = new Flag((Object)false);
        }

        public Flag<Boolean> getFinished() {
            return this.finished;
        }

        public EExperimentRunResult getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = this.this$0.runExperimentInternal(this.experiment);
            }
            catch (Exception ex) {
                this.result = EExperimentRunResult.EXCEPTION;
                this.this$0.logger.error((Object)"Exception during experiment.", (Throwable)ex);
            }
            this.finished.setFlag((Object)true);
        }
    }
}

