/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.fsm;

import cz.cuni.amis.fsm.FSMBuildException;
import cz.cuni.amis.fsm.FSMInitialState;
import cz.cuni.amis.fsm.FSMOriginalState;
import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTerminalState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSM;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.fsm.IFSMTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FSM<SYMBOL, CONTEXT>
implements IFSM<SYMBOL, CONTEXT> {
    private Collection<StateWrapper<SYMBOL, CONTEXT>> states;
    private Collection<IFSMTransition<SYMBOL, CONTEXT>> transitions;
    private StateWrapper<SYMBOL, CONTEXT> initialState = null;
    private StateWrapper<SYMBOL, CONTEXT> currentState = null;
    private Logger log = null;
    private Object mutex = new Object();

    protected Collection<StateWrapper<SYMBOL, CONTEXT>> getStates() {
        return Collections.unmodifiableCollection(this.states);
    }

    public Collection<IFSMTransition<SYMBOL, CONTEXT>> getTransitions() {
        return Collections.unmodifiableCollection(this.transitions);
    }

    public static IFSMState getState(Class<? extends IFSMState> state, Logger log) {
        try {
            return state.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FSMBuildException("can't construct " + state.getClass().getName() + ": " + e.getMessage(), log);
        }
    }

    protected static IFSMTransition getTransition(Class<? extends IFSMTransition> transition, Logger log) {
        try {
            return transition.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FSMBuildException("can't construct " + transition.getClass().getName() + ": " + e.getMessage(), log);
        }
    }

    public FSM(CONTEXT context, Class<? extends IFSMState<SYMBOL, CONTEXT>> state, Logger log) {
        this(context, FSM.getState(state, log), log);
    }

    public FSM(CONTEXT context, IFSMState<SYMBOL, CONTEXT> state, Logger log) {
        this(context, new IFSMState[]{state}, null, log);
    }

    public FSM(CONTEXT context, IFSMState<SYMBOL, CONTEXT>[] states, IFSMTransition[] transitions, Logger log) {
        StateWrapper[] tempStates;
        this.log = log;
        if (states == null) {
            throw new FSMBuildException("states can't be null", log);
        }
        HashMap statesMap = new HashMap();
        HashMap transitionsMap = new HashMap();
        for (IFSMState<SYMBOL, CONTEXT> state : states) {
            if (state == null) continue;
            StateWrapper wrapper = new StateWrapper(state, log);
            statesMap.put(state.getClass(), wrapper);
        }
        if (transitions != null) {
            for (IFSMTransition transition : transitions) {
                if (transition == null) continue;
                transitionsMap.put(transition.getClass(), transition);
                this.transitions.add(transition);
            }
        }
        for (StateWrapper wrapper : tempStates = statesMap.values().toArray(new StateWrapper[0])) {
            wrapper.initTransitionMap(statesMap, transitionsMap);
        }
        this.states = statesMap.values();
        this.transitions = transitionsMap.values();
        for (StateWrapper<SYMBOL, CONTEXT> wrapper : this.states) {
            if (!((StateWrapper)wrapper).myState.getClass().isAnnotationPresent(FSMInitialState.class)) continue;
            if (this.initialState != null) {
                throw new FSMBuildException("there are more then one initial state, examples: " + ((StateWrapper)this.initialState).myState.getClass() + ", " + ((StateWrapper)wrapper).myState.getClass(), log);
            }
            this.initialState = wrapper;
        }
        this.init(context);
    }

    private void init(CONTEXT context) {
        this.currentState = this.initialState;
        for (StateWrapper<SYMBOL, CONTEXT> stateWrapper : this.states) {
            stateWrapper.init(context);
        }
        for (IFSMTransition iFSMTransition : this.transitions) {
            iFSMTransition.init(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminal() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentState.isTerminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(CONTEXT context, SYMBOL symbol) {
        Object object = this.mutex;
        synchronized (object) {
            this.currentState = this.currentState.pushSymbol(context, symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart(CONTEXT context) {
        Object object = this.mutex;
        synchronized (object) {
            this.currentState = this.initialState;
            for (StateWrapper<SYMBOL, CONTEXT> stateWrapper : this.states) {
                stateWrapper.restart(context);
            }
            for (IFSMTransition iFSMTransition : this.transitions) {
                iFSMTransition.restart(context);
            }
        }
    }

    protected static class StateWrapper<SYMBOL, CONTEXT>
    implements IFSMState<SYMBOL, CONTEXT> {
        private IFSMState<SYMBOL, CONTEXT> myState;
        private Map<Class, TransitionWrapper<SYMBOL, CONTEXT>> transitions = new HashMap<Class, TransitionWrapper<SYMBOL, CONTEXT>>();
        private boolean terminal;
        private Logger log;

        public StateWrapper(IFSMState<SYMBOL, CONTEXT> state, Logger log) {
            this.log = log;
            if (!state.getClass().isAnnotationPresent(FSMState.class)) {
                throw new FSMBuildException("state " + state.getClass() + " doesn't contain @State annotation", log);
            }
            this.myState = state;
            this.terminal = state.getClass().isAnnotationPresent(FSMTerminalState.class);
        }

        protected void initTransitionMap(Map<Class, StateWrapper<SYMBOL, CONTEXT>> states, Map<Class, IFSMTransition<SYMBOL, CONTEXT>> transitions) {
            FSMState s = this.myState.getClass().getAnnotation(FSMState.class);
            for (FSMTransition transition : s.map()) {
                if (transition.symbol().length == 0) {
                    throw new FSMBuildException("state " + this.myState.getClass() + ": one of the transition doesn't have symbols specified", this.log);
                }
                StateWrapper<SYMBOL, CONTEXT> targetState = null;
                if (transition.state() != FSMOriginalState.class && (targetState = states.get(transition.state())) == null) {
                    targetState = new StateWrapper<SYMBOL, CONTEXT>(FSM.getState(transition.state(), this.log), this.log);
                    states.put(transition.state(), targetState);
                    targetState.initTransitionMap(states, transitions);
                }
                ArrayList nextTransitions = new ArrayList(transition.transition().length);
                for (Class<? extends IFSMTransition> tran : transition.transition()) {
                    IFSMTransition t = transitions.get(tran);
                    if (t == null) {
                        t = FSM.getTransition(tran, this.log);
                        transitions.put(tran, t);
                    }
                    nextTransitions.add(t);
                }
                TransitionWrapper<SYMBOL, CONTEXT> transitionWrapper = new TransitionWrapper<SYMBOL, CONTEXT>(targetState, nextTransitions, this.log);
                for (Class symbol : transition.symbol()) {
                    this.transitions.put(symbol, transitionWrapper);
                }
            }
        }

        @Override
        public void init(CONTEXT context) {
            this.log.finest("FSM: " + this.myState + " init()");
            this.myState.init(context);
        }

        @Override
        public void restart(CONTEXT context) {
            this.log.finest("FSM: " + this.myState + " restart()");
            this.myState.restart(context);
        }

        @Override
        public void stateEntering(CONTEXT context, IFSMState<SYMBOL, CONTEXT> fromState, SYMBOL symbol) {
            this.log.finest("FSM[" + fromState + "]: entering state " + this.myState);
            this.myState.stateEntering(context, fromState, symbol);
        }

        @Override
        public void stateLeaving(CONTEXT context, IFSMState<SYMBOL, CONTEXT> toState, SYMBOL symbol) {
            this.log.finest("FSM[" + this.myState + "]: leaving state");
            this.myState.stateLeaving(context, toState, symbol);
        }

        @Override
        public void stateSymbol(CONTEXT context, SYMBOL symbol) {
            this.log.finest("FSM[" + this.myState + "]: consuming symbol " + symbol);
            this.myState.stateSymbol(context, symbol);
        }

        public StateWrapper pushSymbol(CONTEXT context, SYMBOL symbol) {
            TransitionWrapper<SYMBOL, CONTEXT> transition = this.transitions.get(symbol.getClass());
            if (transition == null) {
                this.stateSymbol(context, symbol);
                return this;
            }
            return transition.step(context, this, symbol);
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            return "FSM$StateWrapper(myState=" + this.myState + ")";
        }

        public IFSMState<SYMBOL, CONTEXT> getWrappedState() {
            return this.myState;
        }

        public Map<Class, TransitionWrapper<SYMBOL, CONTEXT>> getTransitions() {
            return Collections.unmodifiableMap(this.transitions);
        }
    }

    protected static class TransitionWrapper<SYMBOL, CONTEXT> {
        private StateWrapper<SYMBOL, CONTEXT> target;
        private List<IFSMTransition<SYMBOL, CONTEXT>> transitions;
        private Logger log;

        public TransitionWrapper(StateWrapper<SYMBOL, CONTEXT> target, Logger log) {
            this(target, null, log);
        }

        public TransitionWrapper(StateWrapper<SYMBOL, CONTEXT> target, List<IFSMTransition<SYMBOL, CONTEXT>> transitions, Logger log) {
            this.log = log;
            this.target = target;
            this.transitions = transitions;
        }

        public StateWrapper<SYMBOL, CONTEXT> step(CONTEXT context, StateWrapper<SYMBOL, CONTEXT> fromState, SYMBOL bySymbol) {
            this.log.finer("FSM[" + fromState.getWrappedState() + "]: symbol " + bySymbol);
            if (this.target == null) {
                for (IFSMTransition<SYMBOL, CONTEXT> transition : this.transitions) {
                    this.log.finest("FSM[" + fromState.getWrappedState() + "]: invoking transition " + transition);
                    transition.stepped(context, ((StateWrapper)fromState).myState, bySymbol, this.target);
                }
                return fromState;
            }
            fromState.stateLeaving(context, this.target, bySymbol);
            for (IFSMTransition<SYMBOL, CONTEXT> transition : this.transitions) {
                this.log.finest("FSM[" + fromState.getWrappedState() + "]: invoking transition " + transition);
                transition.stepped(context, ((StateWrapper)fromState).myState, bySymbol, ((StateWrapper)this.target).myState);
            }
            this.target.stateEntering(context, ((StateWrapper)fromState).myState, bySymbol);
            return this.target;
        }

        public StateWrapper<SYMBOL, CONTEXT> getTarget() {
            return this.target;
        }
    }
}

