/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.message.ActiveMQTopic;
import org.codehaus.activemq.web.NoDestinationSuppliedException;
import org.codehaus.activemq.web.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MessageServletSupport
extends HttpServlet {
    private boolean defaultTopicFlag = true;
    private Destination defaultDestination;
    private String destinationParameter = "destination";
    private String topicParameter = "topic";
    private String bodyParameter = "body";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String name = servletConfig.getInitParameter("topic");
        if (name != null) {
            this.defaultTopicFlag = MessageServletSupport.asBoolean((String)name);
        }
        this.log("Defaulting to use topics: " + this.defaultTopicFlag);
        name = servletConfig.getInitParameter("destination");
        if (name != null) {
            this.defaultDestination = this.defaultTopicFlag ? new ActiveMQTopic(name) : new ActiveMQQueue(name);
        }
        WebClient.initContext((ServletContext)this.getServletContext());
    }

    protected WebClient createWebClient(HttpServletRequest request) {
        return new WebClient(this.getServletContext());
    }

    public static boolean asBoolean(String param) {
        return param != null && param.equalsIgnoreCase("true");
    }

    protected WebClient getWebClient(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        WebClient client = WebClient.getWebClient((HttpSession)session);
        if (client == null) {
            client = this.createWebClient(request);
            session.setAttribute("org.codehaus.activemq.webclient", (Object)client);
        }
        return client;
    }

    protected void appendParametersToMessage(HttpServletRequest request, TextMessage message) throws JMSException {
        Iterator iter = request.getParameterMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            if (this.destinationParameter.equals(name) || this.topicParameter.equals(name) || this.bodyParameter.equals(name)) continue;
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length == 1) {
                    value = array[0];
                } else {
                    this.log("Can't use property: " + name + " which is of type: " + value.getClass().getName() + " value");
                    value = null;
                    int size = array.length;
                    for (int i = 0; i < size; ++i) {
                        this.log("value[" + i + "] = " + array[i]);
                    }
                }
            }
            if (value == null) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request) throws JMSException, NoDestinationSuppliedException {
        String destinationName = request.getParameter(this.destinationParameter);
        if (destinationName == null) {
            if (this.defaultDestination == null) {
                return this.getDestinationFromURI(client, request);
            }
            return this.defaultDestination;
        }
        return this.getDestination(client, request, destinationName);
    }

    protected Destination getDestinationFromURI(WebClient client, HttpServletRequest request) throws NoDestinationSuppliedException, JMSException {
        String uri = request.getPathInfo();
        if (uri == null) {
            throw new NoDestinationSuppliedException();
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        uri = uri.replace('/', '.');
        return this.getDestination(client, request, uri);
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request, String destinationName) throws JMSException {
        if (this.isTopic(request)) {
            return client.getSession().createTopic(destinationName);
        }
        return client.getSession().createQueue(destinationName);
    }

    protected boolean isTopic(HttpServletRequest request) {
        boolean aTopic = this.defaultTopicFlag;
        String aTopicText = request.getParameter(this.topicParameter);
        if (aTopicText != null) {
            aTopic = MessageServletSupport.asBoolean((String)aTopicText);
        }
        return aTopic;
    }

    protected long asLong(String name) {
        return Long.parseLong(name);
    }

    protected String getPostedMessageBody(HttpServletRequest request) throws IOException {
        String answer = request.getParameter(this.bodyParameter);
        if (answer == null) {
            String line;
            BufferedReader reader = request.getReader();
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            return buffer.toString();
        }
        return answer;
    }
}

