/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.CacheInterface;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.FlagSnapshoot;

public class FlagsCache
implements CacheInterface {
    private Map<IWorldView, FlagsListener> listeners = new HashMap<IWorldView, FlagsListener>();
    private Map<UnrealId, List<FlagSnapshoot>> itemsHistory = Collections.synchronizedMap(new HashMap());
    public static final int HISTORYSIZE = 10;

    public FlagsCache(IWorldView worldView) {
        this.addAnotherViewer(worldView);
    }

    @Override
    public void addAnotherViewer(IWorldView worldView) {
        FlagsListener tmp = new FlagsListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(FlagInfo.class, (IWorldObjectEventListener)tmp);
    }

    @Override
    public void removeViewer(IWorldView worldView) {
        FlagsListener tmp = this.listeners.get(worldView);
        this.listeners.remove(worldView);
        worldView.removeObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)tmp);
    }

    public List<FlagSnapshoot> getFlagHistory(UnrealId id) {
        return Collections.unmodifiableList(this.itemsHistory.get(id));
    }

    public Map<UnrealId, List<FlagSnapshoot>> getFlagsHistory() {
        return Collections.unmodifiableMap(this.itemsHistory);
    }

    protected void notify(FlagInfo event) {
        List<FlagSnapshoot> oneItemHistory = this.itemsHistory.get(event.getId());
        if (oneItemHistory == null) {
            oneItemHistory = Collections.synchronizedList(new LinkedList());
            this.itemsHistory.put(event.getId(), oneItemHistory);
        }
        oneItemHistory.add(0, new FlagSnapshoot(event));
        while (oneItemHistory.size() > 10) {
            oneItemHistory.remove(10);
        }
    }

    private class FlagsListener
    implements IWorldObjectListener<FlagInfo> {
        private FlagsListener() {
        }

        public void notify(IWorldObjectEvent<FlagInfo> event) {
            FlagsCache.this.notify((FlagInfo)event.getObject());
        }
    }
}

