/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.bot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionHistoryStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.Collection;
import java.util.Random;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;

public abstract class AbstractBotWithJungigation
extends UT2004BotLogicController<UT2004Bot> {
    protected Logger log = Logger.getLogger(AbstractBotWithJungigation.class);
    private final Random rnd = new Random();
    public NavigationGraphSynchronized navigationGraph;
    public Collection<NavPoint> navpoints;
    public UT2004PathExecutor<ILocated> pathExecutor;
    @JProp
    protected String mapName;
    protected IStuckDetector sd;
    protected GameInfo gameInfo = null;

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        super.botInitialized(gameInfo, config, init);
        GameTime.startUpdatingTime((IWorldView)this.getWorldView());
        this.gameInfo = gameInfo;
        long startTime = System.currentTimeMillis();
        this.log.info((Object)"Going to get all NavPoints ftom world.");
        this.navpoints = this.bot.getWorldView().getAll(NavPoint.class).values();
        this.mapName = this.gameInfo.getLevel();
        this.navigationGraph = NavigationGraphProviderForMap.getInstance().getNavigationDataForMapWithChceckAndInitialization(this.mapName, this.navpoints);
        long endTime = System.currentTimeMillis();
        this.log.info((Object)("Navigation graph constructed in " + (endTime - startTime) + " ms."));
        this.log.info((Object)"Going to plan first random target.");
        this.pathExecutor = new UT2004PathExecutor(this.bot);
        this.sd = new UT2004PositionHistoryStuckDetector(this.bot);
        this.pathExecutor.addStuckDetector(this.sd);
    }

    public NavPoint pickNewRandomNavTarget() {
        Collection navPoints = this.getWorldView().getAll(NavPoint.class).values();
        int navPointIndex = this.rnd.nextInt(navPoints.size());
        int i = 0;
        for (NavPoint nav : navPoints) {
            if (i == navPointIndex) {
                return nav;
            }
            ++i;
        }
        throw new RuntimeException("No navpoint chosen. There are no navpoints in the list of known navpoints");
    }

    public UT2004Bot getBot() {
        return this.bot;
    }
}

