/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm.AStar;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Stack;
import java.util.TreeSet;
import jung.myalghoritm.AStar.VerticeForAStar;
import jung.myalghoritm.AStar.VerticeForAStarComparator;
import jung.myalghoritm.MyShortestPath;
import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;
import org.apache.log4j.Logger;

public abstract class AbstractAStarPathPlanner<V, E>
implements MyShortestPath<V, E> {
    private static final Logger log = Logger.getLogger(AbstractAStarPathPlanner.class);
    protected final Graph<V, E> g;
    public final int implementation;

    public AbstractAStarPathPlanner(Graph<V, E> navigationGraph, EdgeAndVertexToNumberWeightTransformer<V, E> transformer, int implementation) {
        this.g = navigationGraph;
        this.implementation = implementation;
    }

    public abstract Double heuristicEstimateOfDistance(V var1, V var2);

    public abstract Double distanceBetween(V var1, V var2);

    @Override
    public List<E> getPath(V from, V to) {
        double estimation;
        HashMap closedMap = new HashMap();
        TreeSet opensetSorted = new TreeSet(new VerticeForAStarComparator());
        VerticeForAStar<V> fromV = new VerticeForAStar<V>(from);
        opensetSorted.add(fromV);
        HashMap<VerticeForAStar<VerticeForAStar>, VerticeForAStar<VerticeForAStar>> came_from = new HashMap<VerticeForAStar<VerticeForAStar>, VerticeForAStar<VerticeForAStar>>();
        fromV.f_score = estimation = this.heuristicEstimateOfDistance(from, to).doubleValue();
        fromV.h_score = estimation;
        int i = 0;
        VerticeForAStar goal = null;
        switch (this.implementation) {
            case 0: {
                PriorityQueue pQueue = new PriorityQueue(40, new VerticeForAStarComparator());
                pQueue.add(fromV);
                while (!pQueue.isEmpty()) {
                    ++i;
                    VerticeForAStar x = (VerticeForAStar)pQueue.poll();
                    if (x.vertice.equals(to)) {
                        List<V> path = this.reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
                        return this.convertPathRepresentation(path);
                    }
                    pQueue.remove(x);
                    closedMap.put(x.vertice, x);
                    Collection neighbors = this.g.getSuccessors(x.vertice);
                    for (Object yy : neighbors) {
                        boolean tentative_is_better;
                        VerticeForAStar y = (VerticeForAStar)closedMap.get(yy);
                        if (y != null) continue;
                        y = new VerticeForAStar(yy);
                        double tentative_g_score = x.g_score + this.distanceBetween(x.vertice, y.vertice);
                        if (!pQueue.contains(y)) {
                            pQueue.add(y);
                            tentative_is_better = true;
                        } else {
                            tentative_is_better = tentative_g_score < y.g_score;
                        }
                        if (!tentative_is_better) continue;
                        pQueue.remove(y);
                        y.g_score = tentative_g_score;
                        y.h_score = this.heuristicEstimateOfDistance(y.vertice, to);
                        y.f_score = y.g_score + y.h_score;
                        pQueue.add(y);
                        came_from.put(y, x);
                    }
                }
                return null;
            }
            case 1: {
                while (!opensetSorted.isEmpty()) {
                    VerticeForAStar x = (VerticeForAStar)opensetSorted.first();
                    opensetSorted.remove(x);
                    if (x.vertice.equals(to)) {
                        if (log.isDebugEnabled()) {
                            // empty if block
                        }
                        goal = x;
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        // empty if block
                    }
                    closedMap.put(x.vertice, x);
                    Collection neighbors = this.g.getSuccessors(x.vertice);
                    for (Object neighbor2 : neighbors) {
                        VerticeForAStar visited = (VerticeForAStar)closedMap.get(neighbor2);
                        if (visited != null) continue;
                        double g = x.g_score + this.distanceBetween(x.vertice, neighbor2);
                        VerticeForAStar n = new VerticeForAStar(neighbor2);
                        if (!opensetSorted.contains(visited)) {
                            n.g_score = g;
                            n.h_score = n.f_score = this.heuristicEstimateOfDistance(neighbor2, to).doubleValue();
                            came_from.put(n, x);
                            opensetSorted.add(n);
                            continue;
                        }
                        if (!(g < n.g_score)) continue;
                        opensetSorted.remove(n);
                        came_from.put(n, x);
                        n.g_score = g;
                        n.h_score = this.heuristicEstimateOfDistance(neighbor2, to);
                        n.h_score = n.f_score;
                        opensetSorted.add(n);
                    }
                }
                if (goal != null) {
                    Stack stack = new Stack();
                    ArrayList list = new ArrayList();
                    stack.push(goal.vertice);
                    VerticeForAStar parent = (VerticeForAStar)came_from.get(goal);
                    while (parent != null) {
                        stack.push(parent.vertice);
                        parent = (VerticeForAStar)came_from.get(parent);
                    }
                    if (log.isDebugEnabled()) {
                        // empty if block
                    }
                    while (stack.size() > 0) {
                        if (log.isDebugEnabled()) {
                            // empty if block
                        }
                        list.add(stack.pop());
                    }
                    return this.convertPathRepresentation(list);
                }
                return null;
            }
            case 2: {
                while (!opensetSorted.isEmpty()) {
                    ++i;
                    VerticeForAStar x = (VerticeForAStar)opensetSorted.first();
                    if (x.vertice.equals(to)) {
                        List<V> path = this.reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
                        return this.convertPathRepresentation(path);
                    }
                    opensetSorted.remove(x);
                    closedMap.put(x.vertice, x);
                    Collection neighbors = this.g.getSuccessors(x.vertice);
                    for (Object yy : neighbors) {
                        boolean tentative_is_better;
                        VerticeForAStar y = (VerticeForAStar)closedMap.get(yy);
                        if (y != null) continue;
                        y = new VerticeForAStar(yy);
                        double tentative_g_score = x.g_score + this.distanceBetween(x.vertice, y.vertice);
                        if (!opensetSorted.contains(y)) {
                            opensetSorted.add(y);
                            tentative_is_better = true;
                        } else {
                            tentative_is_better = tentative_g_score < y.g_score;
                        }
                        if (!tentative_is_better) continue;
                        opensetSorted.remove(y);
                        y.g_score = tentative_g_score;
                        y.h_score = this.heuristicEstimateOfDistance(y.vertice, to);
                        y.f_score = y.g_score + y.h_score;
                        opensetSorted.add(y);
                        came_from.put(y, x);
                    }
                }
                return null;
            }
            case 3: {
                while (!opensetSorted.isEmpty()) {
                    ++i;
                    VerticeForAStar x = (VerticeForAStar)opensetSorted.first();
                    if (x.vertice.equals(to)) {
                        List<V> path = this.reconstruct_path(new VerticeForAStar<V>(from), new VerticeForAStar<V>(to), came_from);
                        return this.convertPathRepresentation(path);
                    }
                    opensetSorted.remove(x);
                    closedMap.put(x.vertice, x);
                    Collection neighbors = this.g.getSuccessors(x.vertice);
                    for (Object yy : neighbors) {
                        boolean tentative_is_better;
                        VerticeForAStar y = (VerticeForAStar)closedMap.get(yy);
                        if (y != null) continue;
                        y = new VerticeForAStar(yy);
                        double tentative_g_score = x.g_score + this.distanceBetween(x.vertice, y.vertice);
                        if (!opensetSorted.contains(y)) {
                            opensetSorted.add(y);
                            tentative_is_better = true;
                        } else {
                            tentative_is_better = tentative_g_score < y.g_score;
                        }
                        if (!tentative_is_better) continue;
                        opensetSorted.remove(y);
                        y.g_score = tentative_g_score;
                        y.h_score = this.heuristicEstimateOfDistance(y.vertice, to);
                        y.f_score = y.g_score + y.h_score;
                        opensetSorted.add(y);
                        if (came_from.get(y) != null) {
                            if (!(x.f_score < ((VerticeForAStar)came_from.get(y)).f_score)) continue;
                            came_from.put(y, x);
                            continue;
                        }
                        came_from.put(y, x);
                    }
                }
                return null;
            }
        }
        throw new RuntimeException("unknown implementation code! implementation=" + this.implementation);
    }

    protected List<V> reconstruct_path(VerticeForAStar<V> came_from, VerticeForAStar<V> current_node, Map<VerticeForAStar<V>, VerticeForAStar<V>> came_from_map) {
        VerticeForAStar<V> currentNodeCameFrom = came_from_map.get(current_node);
        if (currentNodeCameFrom != null) {
            List<V> navrat = this.reconstruct_path(came_from, came_from_map.get(current_node), came_from_map);
            navrat.add(current_node.vertice);
            return navrat;
        }
        LinkedList navrat = new LinkedList();
        navrat.add(current_node.vertice);
        return navrat;
    }

    protected List<E> convertPathRepresentation(List<V> path) {
        int length = path.size();
        ArrayList<Object> navrat = new ArrayList<Object>(--length);
        for (int i = 0; i < length; ++i) {
            V v1 = path.get(i);
            V v2 = path.get(i + 1);
            navrat.add(this.g.findEdge(v1, v2));
        }
        return navrat;
    }

    public String toString() {
        return "AbstractAStarPathPlanner(impl:" + this.implementation + ")";
    }
}

