package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.AdvancedSharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.SharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.FlagSnapshoot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AdvancedItems;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;

/**
 * TODO spravit to cez templejty asi. Kazdeho cache.
 * 
 * @author LuVar
 * 
 */
public class FlagsCache implements CacheInterface {
	private Map<IWorldView, FlagsListener> listeners = new HashMap<IWorldView, FlagsListener>();
	private Map<UnrealId, List<FlagSnapshoot>> itemsHistory = Collections.synchronizedMap(new HashMap<UnrealId, List<FlagSnapshoot>>());
	
	public static final int HISTORYSIZE = 10;
	
	/**
	 * <p>
	 * For similar functionality look in see section.
	 * </p>
	 * 
	 * @param worldView
	 * 
	 * @see FlagsCache
	 * @see PlayersCache
	 * @see SharedItems
	 * @see AdvancedSharedItems
	 * @see Items
	 * @see AdvancedItems
	 */
	public FlagsCache(IWorldView worldView) {
		this.addAnotherViewer(worldView);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#addAnotherViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	public void addAnotherViewer(IWorldView worldView) {
		FlagsListener tmp = new FlagsListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(FlagInfo.class, tmp);
	}
	
	/**
	 * @see sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#removeViewer(cz.cuni.amis.pogamut.base.communication.worldview.IWorldView)
	 */
	public void removeViewer(IWorldView worldView) {
		FlagsListener tmp = this.listeners.get(worldView);
		this.listeners.remove(worldView);
		worldView.removeObjectListener(FlagInfo.class, WorldObjectUpdatedEvent.class, tmp);
	}
	
	/**
	 * <p>
	 * Returns list of last known states for desired item. Returned list is unmodifiable.
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<FlagSnapshoot> getFlagHistory(UnrealId id) {
		return Collections.unmodifiableList(this.itemsHistory.get(id));
	}
	
	/**
	 * <p>
	 * Whole items history. Unmodifiable.
	 * </p>
	 * 
	 * @return
	 */
	public Map<UnrealId, List<FlagSnapshoot>> getFlagsHistory() {
		return Collections.unmodifiableMap(this.itemsHistory);
	}
	
	protected void notify(FlagInfo event) {
		List<FlagSnapshoot> oneItemHistory = this.itemsHistory.get(event.getId());
		if (oneItemHistory == null) {
			// TODO choose best implementation of list or code own, synchronized
			oneItemHistory = Collections.synchronizedList(new LinkedList<FlagSnapshoot>());
			this.itemsHistory.put(event.getId(), oneItemHistory);
		}// end of if itemHistory == null
		oneItemHistory.add(0, new FlagSnapshoot(event));
		// keep just last 10 item states
		while (oneItemHistory.size() > FlagsCache.HISTORYSIZE) {
			oneItemHistory.remove(FlagsCache.HISTORYSIZE);
		}
	}
	
	private class FlagsListener implements IWorldObjectListener<FlagInfo> {
		@Override
		public void notify(IWorldObjectEvent<FlagInfo> event) {
			FlagsCache.this.notify(event.getObject());
		}// end of method notify
	}// end of private class ItemsCache
}
