package jung.myio;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;

/**
 * Interface for a writer of graph objects
 *
 * @author LuVar - luvar@plaintext.sk
 * 
 * @param <G>
 *            the graph type
 * @param <V>
 *            the vertex type
 * @param <E>
 *            the edge type
 */
public interface GraphWriter<G extends Hypergraph<V, E>, V, E> {

    /**
     * Writes a single graph object
     * 
     * @throws GraphIOException
     *             thrown if an error occurred.
     */
    void writeGraph(G g) throws GraphIOException;

    /**
     * Closes this resource and frees any resources.
     * 
     * @throws GraphIOException
     *             thrown if an error occurred.
     */
    void close() throws GraphIOException;
}