package jung.myalghoritm.AStar;

import javax.vecmath.Point2d;

import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;

import org.apache.commons.collections15.Transformer;

import edu.uci.ics.jung.graph.Graph;

/**
 * Simplest possible AStar path planner with heuristic based on spatial distances.
 */
public class SimplestAStarPathPlanner<V,E> extends AbstractAStarPathPlanner<V,E> {
    private final Transformer<V, Point2d> transformerPositions;

    public SimplestAStarPathPlanner(Graph<V, E> navigationGraph, EdgeAndVertexToNumberWeightTransformer<V, E> transformer, Transformer<V, Point2d> transformerPositions, int implementation) {
	super(navigationGraph, transformer, implementation);
	this.transformerPositions = transformerPositions;
    }

    @Override
    public Double heuristicEstimateOfDistance(V a, V b) {
	Point2d ap = this.transformerPositions.transform(a);
	Point2d bp = this.transformerPositions.transform(b);
	double distance = ap.distance(bp);
	return distance;
    }

    @Override
    public Double distanceBetween(V a, V b) {
	Point2d ap = this.transformerPositions.transform(a);
	Point2d bp = this.transformerPositions.transform(b);
	double distance = ap.distance(bp);
	return distance;
    }
}