/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.AbstractNotifiableCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.PlayersCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.SelfCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.GamerSnapshot;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.PlayerSnapshot;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.SelfSnapshot;

public abstract class GamersCache
extends AbstractNotifiableCache<IWorldObject> {
    private final PlayersCache playersCache;
    private final SelfCache selfCache;
    private UpdateListener<Player> playerListener = new UpdateListener<Player>(){

        @Override
        public void notifyOfChange(Player updatedInstance) {
            GamersCache.this.notifyOfPlayerChange(updatedInstance);
        }
    };
    private UpdateListener<Self> selfListener = new UpdateListener<Self>(){

        @Override
        public void notifyOfChange(Self updatedInstance) {
            GamersCache.this.notifyOfSelfChange(updatedInstance);
        }
    };

    public GamersCache(IWorldView worldView) {
        this.playersCache = new PlayersCache(worldView);
        this.selfCache = new SelfCache(worldView);
        this.playersCache.addListener(this.playerListener);
        this.selfCache.addListener(this.selfListener);
    }

    protected abstract void notifyOfPlayerChange(Player var1);

    protected abstract void notifyOfSelfChange(Self var1);

    @Override
    public void addAnotherViewer(IWorldView worldView) {
        this.playersCache.addAnotherViewer(worldView);
        this.selfCache.addAnotherViewer(worldView);
    }

    @Override
    public void removeViewer(IWorldView worldView) {
        this.playersCache.removeViewer(worldView);
        this.selfCache.removeViewer(worldView);
    }

    public Map<UnrealId, List<GamerSnapshot>> getGamersHistory() {
        ArrayList<GamerSnapshot> listConverted;
        HashMap<UnrealId, List<GamerSnapshot>> navrat = new HashMap<UnrealId, List<GamerSnapshot>>(this.playersCache.getNumberOfPlayers());
        Map<UnrealId, List<SelfSnapshot>> selfs = this.selfCache.getSelfsHistory();
        Map<UnrealId, List<PlayerSnapshot>> players = this.playersCache.getPlayersHistory();
        Set<Map.Entry<UnrealId, List<PlayerSnapshot>>> aaa = players.entrySet();
        aaa = Collections.synchronizedSet(aaa);
        for (Map.Entry<UnrealId, List<PlayerSnapshot>> entry : aaa) {
            listConverted = new ArrayList<GamerSnapshot>(entry.getValue().size());
            for (PlayerSnapshot object : entry.getValue()) {
                listConverted.add(new GamerSnapshot(object));
            }
            navrat.put(entry.getKey(), listConverted);
        }
        for (Map.Entry<UnrealId, List<PlayerSnapshot>> entry : selfs.entrySet()) {
            listConverted = new ArrayList(entry.getValue().size());
            for (PlayerSnapshot object : entry.getValue()) {
                listConverted.add(new GamerSnapshot((SelfSnapshot)object));
            }
            navrat.put(entry.getKey(), listConverted);
        }
        return navrat;
    }

    public List<PlayerSnapshot> getPlayerHistory(UnrealId id) {
        return this.playersCache.getPlayerHistory(id);
    }

    public List<SelfSnapshot> getSelfHistory(UnrealId id) {
        return this.selfCache.getSelfHistory(id);
    }
}

