/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm.AStar;

import edu.uci.ics.jung.graph.Graph;
import java.util.List;
import javax.vecmath.Point2d;
import jung.myalghoritm.AStar.SimplestAStarPathPlanner;
import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;
import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;

public class SimplestAStarPathPlannerForUT2004
extends SimplestAStarPathPlanner<MyVertice, MyEdge> {
    public SimplestAStarPathPlannerForUT2004(Graph<MyVertice, MyEdge> navigationGraph, EdgeAndVertexToNumberWeightTransformer<MyVertice, MyEdge> transformer, Transformer<MyVertice, Point2d> transformerPositions, int implementation) {
        super(navigationGraph, transformer, transformerPositions, implementation);
    }

    @Override
    public Double heuristicEstimateOfDistance(MyVertice a, MyVertice b) {
        double distance = super.heuristicEstimateOfDistance(a, b) / 4.0 + b.valueAdded;
        return distance;
    }

    @Override
    public Double distanceBetween(MyVertice a, MyVertice b) {
        MyEdge e = (MyEdge)this.g.findEdge((Object)a, (Object)b);
        if (e == null) {
            throw new RuntimeException("Cannot compute direct distance. I am not able to find edge between vertices " + a + " and " + b + ". Vertices are not connected by edge!");
        }
        double additionalCost = e.getTravelTime();
        if (Double.isNaN(additionalCost) || Double.isInfinite(additionalCost)) {
            additionalCost = 10000.0;
        }
        return b.valueAdded + additionalCost;
    }

    public static double getPathDuration(List<MyEdge> path) {
        double navrat = 0.0;
        for (MyEdge myEdge : path) {
            navrat += myEdge.getTravelTime();
        }
        return navrat;
    }
}

