package sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;
import jung.myalghoritm.dynamicWeigths.WeigthForItem;

import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToTimeNumberTransformer;
import edu.uci.ics.jung.graph.Graph;

public class EdgeAndVertexToNumberAdvancedTransformer extends EdgeAndVertexToNumberWeightTransformer<MyVertice, MyEdge> {
	private static final Logger log = Logger.getLogger(EdgeAndVertexToNumberAdvancedTransformer.class);

	private Map<MyVertice, WeigthForItem> currentMapOfItemInterest;

	private final Map<String, Map<MyVertice, WeigthForItem>> mapsOfWeights = new HashMap<String, Map<MyVertice, WeigthForItem>>();

	public static final String HEALTHINTEREST = "HealthInterest";
	public static final String ARMORINTEREST = "ArmorInterest";
	public static final String JUSTTIMEINTEREST = "JustTimeInterest";

	/**
	 * <p>
	 * Don't forget before using this instance for path planning, to set map of weights by calling
	 * {@link #setActiveProfile(String)}.
	 * </p>
	 * 
	 * @param navigationGraph
	 */
	public EdgeAndVertexToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph) {
		this(navigationGraph, null);
	}

	/**
	 * <p>
	 * Constructor will also put some sample maps of weights to local {@link #mapsOfWeigths}.
	 * </p>
	 * 
	 * @param navigationGraph
	 * @param mapOfItemInterest
	 */
	public EdgeAndVertexToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph, Map<MyVertice, WeigthForItem> mapOfItemInterest) {
		super(navigationGraph, null, new EdgeToTimeNumberTransformer());
		this.currentMapOfItemInterest = mapOfItemInterest;
		this.setCurrentTransformerInterestForVertex(this.verticeTransformer);

		if (navigationGraph == null) {
			System.out.println("navigationGraph is null. No profile will be created!");
		} else {
			this.putNewProfile(HEALTHINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getHealthInterestMapForNavpoints(this.navigationGraph));
			this.putNewProfile(ARMORINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getArmorInterestMapForNavpoints(this.navigationGraph));
			this.putNewProfile(JUSTTIMEINTEREST, EdgeAndVertexToNumberAdvancedTransformer.getJustTimeInterestMapForNavpoints(this.navigationGraph));
			this.setActiveProfile(ARMORINTEREST);
		}
	}

	private Transformer<MyVertice, Number> verticeTransformer = new Transformer<MyVertice, Number>() {
		@Override
		public Number transform(MyVertice input) {
			// default offset
			//double navrat = 0.7;
			//TODO finish implementation
			double navrat = input.valueAdded;
			WeigthForItem weigthForItem = EdgeAndVertexToNumberAdvancedTransformer.this.currentMapOfItemInterest.get(input);
			if (weigthForItem != null) {
				navrat -= weigthForItem.getOffsetAdd();
				if (input.getItemAmount() != -1) {
					navrat -= weigthForItem.getAmountMultiplier() * input.getItemAmount();
				}
			}
			// TODO tu by mal byt dostupny wordl prophet a mala by sa z neho tahat informacia o pravdepodobnosti, ze tam
			// ta itema je
			if (Double.isInfinite(navrat) || Double.isNaN(navrat)) {
				log.warn("Vertex had no number value! Edge: " + input);
			}
			return navrat;
		}
	};

	/**
	 * <p>
	 * Set active path planning profile by name.
	 * </p>
	 * 
	 * @param profileName name of desired profile. For example value of {@link #HEALTHINTEREST} can be used
	 * @return true if profile was found in available profiles and set, false otherwise
	 */
	public boolean setActiveProfile(String profileName) {
		Map<MyVertice, WeigthForItem> profileMapOfInterest = this.mapsOfWeights.get(profileName);
		if (profileMapOfInterest == null) {
			return false;
		}
		this.currentMapOfItemInterest = profileMapOfInterest;
		return true;
	}

	/**
	 * <p>
	 * TODO make some methods to help creating interest maps.
	 * </p>
	 * 
	 * @param profileName name of new profile, or name of existing profile which you want to overwrite
	 * @param profileInterestMap interest map for vertices
	 * @return true, if previously was associated no profile with given profile name
	 */
	public boolean putNewProfile(String profileName, Map<MyVertice, WeigthForItem> profileInterestMap) {
		return (this.mapsOfWeights.put(profileName, profileInterestMap) == null);
	}

	public static Map<MyVertice, WeigthForItem> getHealthInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
		Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
		Collection<MyVertice> vertices = navigationGraph.getVertices();
		for (MyVertice vertice : vertices) {
			String itemType = vertice.getItemType();
			if (itemType == null) {
				continue;
			}
			if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
				navrat.put(vertice, new WeigthForItem(0.17f, 50f));
				continue;
			}
			if (itemType.equals("XPickups.AdrenalinePickup")) {
				navrat.put(vertice, new WeigthForItem(1f, 1f));
				continue;
			}
			if (itemType.equals("XPickups.SuperShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.1f, 3f));
				continue;
			}
			if (itemType.equals("XPickups.ShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.1f, 3f));
				continue;
			}
		}// end of for navPoint in navpoints
		return navrat;
	}

	public static Map<MyVertice, WeigthForItem> getJustTimeInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
		Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
		return navrat;
	}

	public static Map<MyVertice, WeigthForItem> getArmorInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
		Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();

		Collection<MyVertice> vertices = new ArrayList<MyVertice>(navigationGraph.getVertices());
		for (MyVertice vertice : vertices) {
			String itemType = vertice.getItemType();
			if (itemType == null) {
				continue;
			}
			if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
				navrat.put(vertice, new WeigthForItem(0.17f, 1f));
				continue;
			}
			if (itemType.equals("XPickups.AdrenalinePickup")) {
				navrat.put(vertice, new WeigthForItem(1f, 1f));
				continue;
			}
			if (itemType.equals("XPickups.SuperShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.15f, 4f));
				continue;
			}
			if (itemType.equals("XPickups.ShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.15f, 2f));
				continue;
			}

			/*
			 * if (itemType.equals(ItemType.BIO_RIFLE_AMMO)) { navrat.put(vertice, new WeigthForItem(0.06f, 6000f));
			 * continue; }
			 */
		}// end of for vertex in vertices
		return navrat;
	}

	public static Map<MyVertice, WeigthForItem> getMachinegunInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
		Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();

		Collection<MyVertice> vertices = new ArrayList<MyVertice>(navigationGraph.getVertices());
		for (MyVertice vertice : vertices) {
			String itemType = vertice.getItemType();
			if (itemType == null) {
				continue;
			}
			if (itemType.equals("XPickups.HealthPack") || itemType.equals("XPickups.MiniHealthPack")) {
				navrat.put(vertice, new WeigthForItem(0.17f, 1f));
				continue;
			}
			if (itemType.equals("XPickups.AdrenalinePickup")) {
				navrat.put(vertice, new WeigthForItem(1f, 1f));
				continue;
			}
			if (itemType.equals("XPickups.SuperShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.1f, 19f));
				continue;
			}
			if (itemType.equals("XPickups.ShieldPack")) {
				navrat.put(vertice, new WeigthForItem(0.1f, 12f));
				continue;
			}

			/*
			 * if (itemType.equals(ItemType.BIO_RIFLE_AMMO)) { navrat.put(vertice, new WeigthForItem(0.06f, 6000f));
			 * continue; }
			 */
		}// end of for vertex in vertices
		return navrat;
	}
}
